/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.util;

import com.google.common.io.ByteArrayDataInput;
import java.nio.charset.StandardCharsets;

public final class ByteBufUtil {
    public static int readVarInt(ByteArrayDataInput in) {
        byte b;
        int i = 0;
        int j = 0;
        do {
            b = in.readByte();
            i |= (b & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b & 0x80) == 128);
        return i;
    }

    public static String readString(ByteArrayDataInput in) {
        int length = ByteBufUtil.readVarInt(in);
        byte[] bytes = new byte[length];
        in.readFully(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private ByteBufUtil() {
    }
}

