/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.version;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.ApolloPlatform;
import com.lunarclient.apollo.api.request.DownloadFileRequest;
import com.lunarclient.apollo.api.request.VersionRequest;
import com.lunarclient.apollo.api.response.VersionResponse;
import com.lunarclient.apollo.option.Option;
import com.lunarclient.apollo.option.SimpleOption;
import com.lunarclient.apollo.version.ApolloVersion;
import io.leangen.geantyref.TypeToken;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.logging.Logger;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public final class ApolloVersionManager {
    public static final SimpleOption<Boolean> SEND_UPDATE_MESSAGE = ((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)Option.builder().comment("Set to 'true' to send opped players available update message, otherwise 'false'.")).node("send-updater-message")).type(TypeToken.get(Boolean.class))).defaultValue(true)).build();
    private VersionResponse updateAssets;
    private final AtomicBoolean updated = new AtomicBoolean(false);

    public ApolloVersionManager() {
        ApolloManager.registerOptions(SEND_UPDATE_MESSAGE);
    }

    public void checkForUpdates() {
        ApolloManager.getHttpManager().request(VersionRequest.builder().build()).onSuccess(response -> {
            ApolloVersion latestVersion;
            ApolloPlatform platform = Apollo.getPlatform();
            String version = response.getVersion();
            ApolloVersion currentVersion = new ApolloVersion(platform.getApolloVersion());
            if (!currentVersion.isUpdateAvailable(latestVersion = new ApolloVersion(version))) {
                return;
            }
            this.updateAssets = response;
            if (!((Boolean)platform.getOptions().get(SEND_UPDATE_MESSAGE)).booleanValue()) {
                return;
            }
            Logger logger = platform.getPlatformLogger();
            logger.warning(String.format("A new version of Apollo is available! Latest release: %s", version));
            if (platform.getPlatform() != ApolloPlatform.Platform.MINESTOM) {
                logger.warning("Please update by running \"/apollo update\" or by downloading the latest build from https://lunarclient.dev/apollo/downloads");
            }
        }).onFailure(Throwable::printStackTrace);
    }

    public void forceUpdate(ApolloPlatform.Platform platform, Consumer<Component> message) {
        File file;
        if (this.updated.get()) {
            message.accept(Component.text("Apollo is already updated, please restart your server!", (TextColor)NamedTextColor.RED));
            return;
        }
        if (this.updateAssets == null) {
            message.accept(Component.text("This server is already running the latest version of Apollo.", (TextColor)NamedTextColor.RED));
            return;
        }
        String downloadUrl = this.getPlatformUrl(platform);
        if (downloadUrl == null) {
            message.accept(Component.text("Unable to find assets to update from.", (TextColor)NamedTextColor.RED));
            return;
        }
        URL url = Apollo.getPlatform().getPlugin().getClass().getProtectionDomain().getCodeSource().getLocation();
        try {
            file = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return;
        }
        String[] urlArgs = downloadUrl.split("/");
        String fileName = urlArgs[urlArgs.length - 1];
        Path updatedJarPath = Paths.get(file.getParent() + File.separator + fileName, new String[0]);
        DownloadFileRequest request = DownloadFileRequest.builder().url(downloadUrl).target(updatedJarPath).build();
        ApolloManager.getHttpManager().download(request).onSuccess(response -> {
            message.accept(Component.text("Successfully updated Apollo, please restart your server!", (TextColor)NamedTextColor.RED));
            file.deleteOnExit();
            this.updated.set(true);
        }).onFailure(throwable -> {
            message.accept(Component.text("Failed to update Apollo, please check your console for more information!", (TextColor)NamedTextColor.RED));
            throwable.printStackTrace();
        });
    }

    private String getPlatformUrl(ApolloPlatform.Platform platform) {
        VersionResponse.Assets assets = this.updateAssets.getAssets();
        switch (platform) {
            case BUKKIT: {
                return assets.getBukkit();
            }
            case BUNGEE: {
                return assets.getBungee();
            }
            case VELOCITY: {
                return assets.getVelocity();
            }
            case FOLIA: {
                return assets.getFolia();
            }
        }
        return null;
    }

    @Generated
    public VersionResponse getUpdateAssets() {
        return this.updateAssets;
    }
}

