/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo;

import com.lunarclient.apollo.libs.configurate.CommentedConfigurationNode;
import com.lunarclient.apollo.libs.configurate.loader.HeaderMode;
import com.lunarclient.apollo.libs.configurate.yaml.NodeStyle;
import com.lunarclient.apollo.libs.configurate.yaml.YamlConfigurationLoader;
import com.lunarclient.apollo.option.config.Serializers;
import com.lunarclient.apollo.util.ConfigTarget;
import java.nio.file.Path;
import java.util.Collection;
import java.util.EnumMap;

public final class ApolloConfig {
    private static final EnumMap<ConfigTarget, ApolloConfig> CONFIGS = new EnumMap(ConfigTarget.class);
    private final YamlConfigurationLoader loader;
    private CommentedConfigurationNode node;

    public static ApolloConfig compute(Path path, ConfigTarget target) {
        return CONFIGS.computeIfAbsent(target, key -> new ApolloConfig(path, (ConfigTarget)((Object)key)));
    }

    public static ApolloConfig get(ConfigTarget target) {
        return CONFIGS.get((Object)target);
    }

    public static Collection<ApolloConfig> configs() {
        return CONFIGS.values();
    }

    ApolloConfig(Path path, ConfigTarget target) {
        this.loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().nodeStyle(NodeStyle.BLOCK).path(path.resolve(target.getFileName()))).headerMode(HeaderMode.PRESET)).defaultOptions(options -> options.serializers(builder -> builder.registerAll(Serializers.serializers())).header(target.getHeaderComment()))).build();
    }

    public CommentedConfigurationNode node() throws Throwable {
        if (this.node != null) {
            return this.node;
        }
        this.node = (CommentedConfigurationNode)this.loader.load();
        return this.node;
    }

    public void save() throws Throwable {
        this.loader.save(this.node);
    }

    public void reset() {
        this.node = null;
    }
}

