/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.player.ApolloPlayer;
import com.lunarclient.apollo.player.ApolloPlayerManager;
import com.lunarclient.apollo.recipients.Recipients;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public final class BungeeApollo {
    public static void runForPlayer(@NonNull ProxiedPlayer player, @NonNull Consumer<ApolloPlayer> playerConsumer) {
        BungeeApollo.runForPlayer(player.getUniqueId(), playerConsumer);
    }

    public static void runForPlayer(@NonNull UUID playerUuid, @NonNull Consumer<ApolloPlayer> playerConsumer) {
        Apollo.getPlayerManager().getPlayer(playerUuid).ifPresent(playerConsumer);
    }

    public static Recipients getRecipientsFrom(@NonNull Collection<ProxiedPlayer> players) {
        ApolloPlayerManager playerManager = Apollo.getPlayerManager();
        List apolloPlayers = players.stream().map(player -> playerManager.getPlayer(player.getUniqueId())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return Recipients.of(apolloPlayers);
    }

    private BungeeApollo() {
    }
}

