/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.command;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.module.ApolloModuleManagerImpl;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import lombok.Generated;
import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public abstract class AbstractApolloCommand<T> {
    protected final BiConsumer<T, Component> textConsumer;
    protected String usage;

    protected void getCurrentVersion(@NonNull T sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.textConsumer.accept(sender, ((TextComponent)Component.text("Apollo is running version ", (TextColor)NamedTextColor.GREEN).append(Component.text(Apollo.getPlatform().getApolloVersion(), (TextColor)NamedTextColor.WHITE))).append(Component.text(".", (TextColor)NamedTextColor.GREEN)));
    }

    protected void reloadConfiguration(@NonNull T sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        try {
            ApolloManager.loadConfiguration();
            ((ApolloModuleManagerImpl)Apollo.getModuleManager()).reloadModules();
            ApolloManager.saveConfiguration();
        }
        catch (Throwable throwable) {
            Apollo.getPlatform().getPlatformLogger().log(Level.SEVERE, "Unable to save Apollo configuration!", throwable);
            this.textConsumer.accept(sender, Component.text("An error occurred attempting to save the configuration!", (TextColor)NamedTextColor.RED));
            return;
        }
        this.textConsumer.accept(sender, Component.text("Reloaded the Apollo configuration!", (TextColor)NamedTextColor.GREEN));
    }

    protected void sendCommandUsage(@NonNull T sender) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        this.textConsumer.accept(sender, Component.text("Usage: ", (TextColor)NamedTextColor.RED).append(Component.text(this.usage, (TextColor)NamedTextColor.RED)));
    }

    @Generated
    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Generated
    public AbstractApolloCommand(BiConsumer<T, Component> textConsumer) {
        this.textConsumer = textConsumer;
    }
}

