/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.libs.configurate.yaml;

import com.lunarclient.apollo.libs.configurate.CommentedConfigurationNodeIntermediary;
import com.lunarclient.apollo.libs.configurate.ConfigurationNode;
import com.lunarclient.apollo.libs.configurate.loader.AbstractConfigurationLoader;
import com.lunarclient.apollo.libs.configurate.yaml.NodeStyle;
import com.lunarclient.apollo.libs.configurate.yaml.ScalarStyle;
import com.lunarclient.apollo.libs.configurate.yaml.YamlCommentHandler;
import com.lunarclient.apollo.libs.configurate.yaml.YamlConfigurationLoader;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.DumperOptions;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.comments.CommentLine;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.comments.CommentType;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.nodes.MappingNode;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.nodes.Node;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.nodes.NodeTuple;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.nodes.ScalarNode;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.nodes.SequenceNode;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.nodes.Tag;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.representer.Represent;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.representer.Representer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

final class YamlRepresenter
extends Representer {
    private static final CommentLine BLANK_LINE = new CommentLine(null, null, "", CommentType.BLANK_LINE);
    private final boolean padComments;

    YamlRepresenter(boolean padComments, DumperOptions options) {
        super(options);
        this.padComments = padComments;
        this.multiRepresenters.put(ConfigurationNode.class, new ConfigurationNodeRepresent());
        this.nullRepresenter = new EmptyNullRepresenter();
    }

    private static final class EmptyNullRepresenter
    implements Represent {
        private EmptyNullRepresenter() {
        }

        @Override
        public Node representData(Object data) {
            return new ScalarNode(Tag.NULL, "", null, null, DumperOptions.ScalarStyle.PLAIN);
        }
    }

    private final class ConfigurationNodeRepresent
    implements Represent {
        private ConfigurationNodeRepresent() {
        }

        @Override
        public Node representData(Object nodeObject) {
            String nodeComment;
            Node yamlNode;
            ArrayList<NodeTuple> children;
            ConfigurationNode node = (ConfigurationNode)nodeObject;
            if (node.isMap()) {
                children = new ArrayList<NodeTuple>();
                for (Map.Entry<Object, ? extends ConfigurationNode> entry : node.childrenMap().entrySet()) {
                    Node value = YamlRepresenter.this.represent(entry.getValue());
                    Node key = YamlRepresenter.this.represent(entry.getKey());
                    key.setBlockComments(value.getBlockComments());
                    value.setBlockComments(Collections.emptyList());
                    children.add(new NodeTuple(key, value));
                }
                yamlNode = new MappingNode(Tag.MAP, children, this.flowStyle(node));
            } else if (node.isList()) {
                children = new ArrayList();
                for (ConfigurationNode configurationNode : node.childrenList()) {
                    children.add((NodeTuple)((Object)YamlRepresenter.this.represent(configurationNode)));
                }
                yamlNode = new SequenceNode(Tag.SEQ, children, this.flowStyle(node));
            } else {
                Node optionNode = YamlRepresenter.this.represent(node.rawScalar());
                @Nullable ScalarStyle requestedStyle = node.ownHint(YamlConfigurationLoader.SCALAR_STYLE);
                if (optionNode instanceof ScalarNode && requestedStyle != null) {
                    ScalarNode scalarNode = (ScalarNode)optionNode;
                    yamlNode = new ScalarNode(scalarNode.getTag(), scalarNode.getValue(), scalarNode.getStartMark(), scalarNode.getEndMark(), ScalarStyle.asSnakeYaml(requestedStyle, scalarNode.getScalarStyle()));
                } else {
                    yamlNode = optionNode;
                }
            }
            if (node instanceof CommentedConfigurationNodeIntermediary && (nodeComment = ((CommentedConfigurationNodeIntermediary)node).comment()) != null) {
                yamlNode.setBlockComments(Arrays.stream(AbstractConfigurationLoader.CONFIGURATE_LINE_PATTERN.split(nodeComment)).map(this::commentLineFor).collect(Collectors.toList()));
            }
            return yamlNode;
        }

        private DumperOptions.FlowStyle flowStyle(ConfigurationNode node) {
            @Nullable NodeStyle requested = node.ownHint(YamlConfigurationLoader.NODE_STYLE);
            return NodeStyle.asSnakeYaml(requested);
        }

        private CommentLine commentLineFor(String comment) {
            if (comment.isEmpty()) {
                return BLANK_LINE;
            }
            if (YamlRepresenter.this.padComments && YamlCommentHandler.applyPadding(comment)) {
                return new CommentLine(null, null, " " + comment, CommentType.BLOCK);
            }
            return new CommentLine(null, null, comment, CommentType.BLOCK);
        }
    }
}

