/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module;

import com.lunarclient.apollo.ApolloPlatform;
import com.lunarclient.apollo.event.ApolloListener;
import com.lunarclient.apollo.module.ModuleDefinition;
import com.lunarclient.apollo.option.Option;
import com.lunarclient.apollo.option.Options;
import com.lunarclient.apollo.option.SimpleOption;
import com.lunarclient.apollo.util.ConfigTarget;
import io.leangen.geantyref.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public abstract class ApolloModule
implements ApolloListener {
    private static final SimpleOption.SimpleOptionBuilder<Boolean> ENABLE_OPTION_BUILDER = (SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)((SimpleOption.SimpleOptionBuilder)Option.builder().comment("Set to 'true' to enable this module, otherwise set 'false'.")).node("enable")).type(TypeToken.get(Boolean.class));
    public static final SimpleOption<Boolean> ENABLE_OPTION_OFF = ((SimpleOption.SimpleOptionBuilder)ENABLE_OPTION_BUILDER.defaultValue(false)).build();
    public static final SimpleOption<Boolean> ENABLE_OPTION_ON = ((SimpleOption.SimpleOptionBuilder)ENABLE_OPTION_BUILDER.defaultValue(true)).build();
    private final List<Option<?, ?, ?>> optionKeys = new LinkedList();
    private boolean enabled;
    private Options options = Options.empty();
    private String id;
    private String name;
    private ConfigTarget configTarget;

    protected ApolloModule() {
        this.registerOptions(ENABLE_OPTION_ON);
    }

    protected void registerOptions(Option<?, ?, ?> ... options) {
        this.optionKeys.addAll(Arrays.asList(options));
    }

    public String getId() {
        if (this.id != null) {
            return this.id;
        }
        this.id = this.definition().id();
        return this.id;
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        this.name = this.definition().name();
        return this.name;
    }

    public ConfigTarget getConfigTarget() {
        if (this.configTarget != null) {
            return this.configTarget;
        }
        this.configTarget = this.definition().configTarget();
        return this.configTarget;
    }

    public Collection<ApolloPlatform.Kind> getSupportedPlatforms() {
        return Collections.singletonList(ApolloPlatform.Kind.SERVER);
    }

    public boolean isClientNotify() {
        return false;
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.onEnable();
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.onDisable();
    }

    protected void onEnable() {
    }

    private void onDisable() {
    }

    private ModuleDefinition definition() {
        Class<?> moduleClass = this.getClass();
        ModuleDefinition definition = moduleClass.getAnnotation(ModuleDefinition.class);
        if (definition == null) {
            moduleClass = moduleClass.getSuperclass();
            definition = moduleClass.getAnnotation(ModuleDefinition.class);
        }
        if (definition == null) {
            throw new RuntimeException("Apollo module class " + moduleClass.getSimpleName() + " must be decorated with a ModuleDefinition annotation");
        }
        return definition;
    }

    @Generated
    List<Option<?, ?, ?>> getOptionKeys() {
        return this.optionKeys;
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public Options getOptions() {
        return this.options;
    }

    @Generated
    void setOptions(Options options) {
        this.options = options;
    }
}

