/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.option;

import com.lunarclient.apollo.option.ListOption;
import com.lunarclient.apollo.option.NumberOption;
import com.lunarclient.apollo.option.OptionBuilder;
import com.lunarclient.apollo.option.SimpleOption;
import io.leangen.geantyref.TypeToken;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public abstract class Option<V, M extends OptionBuilder<V, M, I>, I extends Option<V, M, I>> {
    private final String[] path;
    private final TypeToken<V> typeToken;
    @Nullable
    private final String comment;
    @Nullable
    private final V defaultValue;
    private final boolean notify;

    public static <V> SimpleOption.SimpleOptionBuilder<V> builder() {
        return new SimpleOption.SimpleOptionBuilder();
    }

    public static <V extends Number> NumberOption.NumberOptionBuilder<V> number() {
        return new NumberOption.NumberOptionBuilder();
    }

    public static <T> ListOption.ListOptionBuilder<T> list() {
        return new ListOption.ListOptionBuilder();
    }

    Option(M builder) {
        this.path = Objects.requireNonNull(((OptionBuilder)builder).node, "node");
        this.typeToken = Objects.requireNonNull(((OptionBuilder)builder).typeToken, "typeToken");
        this.comment = ((OptionBuilder)builder).comment;
        this.defaultValue = ((OptionBuilder)builder).defaultValue;
        this.notify = ((OptionBuilder)builder).notify;
    }

    public String getKey() {
        return String.join((CharSequence)".", this.getPath());
    }

    @Generated
    public String[] getPath() {
        return this.path;
    }

    @Generated
    public TypeToken<V> getTypeToken() {
        return this.typeToken;
    }

    @Nullable
    @Generated
    public String getComment() {
        return this.comment;
    }

    @Nullable
    @Generated
    public V getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public boolean isNotify() {
        return this.notify;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Option)) {
            return false;
        }
        Option other = (Option)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNotify() != other.isNotify()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getPath(), other.getPath())) {
            return false;
        }
        TypeToken<V> this$typeToken = this.getTypeToken();
        TypeToken<V> other$typeToken = other.getTypeToken();
        if (this$typeToken == null ? other$typeToken != null : !((Object)this$typeToken).equals(other$typeToken)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        V this$defaultValue = this.getDefaultValue();
        V other$defaultValue = other.getDefaultValue();
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Option;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNotify() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getPath());
        TypeToken<V> $typeToken = this.getTypeToken();
        result = result * 59 + ($typeToken == null ? 43 : ((Object)$typeToken).hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        V $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }
}

