/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.option;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.event.EventBus;
import com.lunarclient.apollo.event.option.ApolloUpdateOptionEvent;
import com.lunarclient.apollo.libs.protobuf.ListValue;
import com.lunarclient.apollo.libs.protobuf.NullValue;
import com.lunarclient.apollo.libs.protobuf.Value;
import com.lunarclient.apollo.module.ApolloModule;
import com.lunarclient.apollo.network.NetworkOptions;
import com.lunarclient.apollo.option.Option;
import com.lunarclient.apollo.option.Options;
import com.lunarclient.apollo.player.ApolloPlayer;
import io.leangen.geantyref.GenericTypeReflector;
import java.awt.Color;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class OptionsImpl
implements Options {
    private final Map<Option<?, ?, ?>, Object> options = Collections.synchronizedMap(new HashMap());
    private final Map<ApolloPlayer, Map<Option<?, ?, ?>, Object>> playerOptions = Collections.synchronizedMap(new WeakHashMap());
    private final ApolloModule module;

    public OptionsImpl(@Nullable ApolloModule module) {
        this.module = module;
    }

    @Override
    public <T, C extends Option<T, ?, ?>> T get(@NonNull C option) {
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        Object value = this.options.get(option);
        return (T)(value == null ? option.getDefaultValue() : value);
    }

    @Override
    @Nullable
    public <T, C extends Option<T, ?, ?>> T get(@NonNull ApolloPlayer player, @NonNull C option) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        Object value = this.playerOptions.getOrDefault(player, Collections.emptyMap()).get(option);
        return (T)(value == null ? this.get(option) : value);
    }

    @Override
    public <T, C extends Option<T, ?, ?>> Optional<T> getDirect(@NonNull C option) {
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        Object value = this.options.get(option);
        return value == null ? Optional.empty() : Optional.of(value);
    }

    @Override
    public <T, C extends Option<T, ?, ?>> Optional<T> getDirect(@NonNull ApolloPlayer player, @NonNull C option) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        Object value = this.playerOptions.getOrDefault(player, Collections.emptyMap()).get(option);
        return value == null ? this.getDirect(option) : Optional.of(value);
    }

    @Override
    public <T> void set(@NonNull Option<?, ?, ?> option, @Nullable T value) {
        Object nextValue;
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        Object object = nextValue = value == null ? option.getDefaultValue() : value;
        if (this.postEvent(option, null, nextValue)) {
            return;
        }
        Object currentValue = Objects.equals(nextValue, option.getDefaultValue()) ? this.options.remove(option) : this.options.put(option, value);
        if (!Objects.equals(currentValue, value)) {
            this.postPacket(option, null, nextValue);
        }
    }

    @Override
    public <T> void set(@NonNull ApolloPlayer player, @NonNull Option<?, ?, ?> option, @Nullable T value) {
        T nextValue;
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        T globalValue = this.get(option);
        T t = nextValue = value == null ? globalValue : value;
        if (this.postEvent(option, player, nextValue)) {
            return;
        }
        Object currentValue = Objects.equals(value, globalValue) ? this.playerOptions.computeIfAbsent(player, k -> Collections.synchronizedMap(new WeakHashMap())).remove(option) : this.playerOptions.computeIfAbsent(player, k -> Collections.synchronizedMap(new WeakHashMap())).put(option, value);
        if (!Objects.equals(currentValue, value)) {
            this.postPacket(option, player, nextValue);
        }
    }

    @Override
    public <T> void add(@NonNull Option<?, ?, ?> option, @NonNull T value) {
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (this.postEvent(option, null, value)) {
            return;
        }
        Object currentValue = this.options.put(option, value);
        if (!Objects.equals(currentValue, value)) {
            this.postPacket(option, null, value);
        }
    }

    @Override
    public <T> void add(@NonNull ApolloPlayer player, @NonNull Option<?, ?, ?> option, @NonNull T value) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (this.postEvent(option, player, value)) {
            return;
        }
        T currentValue = this.playerOptions.computeIfAbsent(player, k -> Collections.synchronizedMap(new WeakHashMap())).put(option, value);
        if (!Objects.equals(currentValue, value)) {
            this.postPacket(option, player, value);
        }
    }

    @Override
    public <T> void remove(@NonNull Option<?, ?, ?> option, @Nullable T compare) {
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        if (this.postEvent(option, null, option.getDefaultValue())) {
            return;
        }
        if (this.options.remove(option, compare)) {
            this.postPacket(option, null, option.getDefaultValue());
        }
    }

    @Override
    public <T> void remove(@NonNull ApolloPlayer player, @NonNull Option<?, ?, ?> option, @Nullable T compare) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        if (this.postEvent(option, player, this.get(option))) {
            return;
        }
        if (this.playerOptions.computeIfAbsent(player, k -> Collections.synchronizedMap(new WeakHashMap())).remove(option, compare)) {
            this.postPacket(option, player, option.getDefaultValue());
        }
    }

    @Override
    public <T> void replace(@NonNull Option<?, ?, ?> option, @NonNull BiFunction<Option<?, ?, ?>, T, T> remappingFunction) {
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        if (remappingFunction == null) {
            throw new NullPointerException("remappingFunction is marked non-null but is null");
        }
        this.options.replaceAll((k, v) -> {
            Object value = remappingFunction.apply(option, v);
            if (value == null) {
                value = option.getDefaultValue();
            }
            if (this.postEvent(option, null, value)) {
                return null;
            }
            if (!Objects.equals(v, value)) {
                this.postPacket(option, null, value);
            }
            return value;
        });
    }

    @Override
    public <T> void replace(@NonNull ApolloPlayer player, @NonNull Option<?, ?, ?> option, @NonNull BiFunction<Option<?, ?, ?>, T, T> remappingFunction) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (option == null) {
            throw new NullPointerException("option is marked non-null but is null");
        }
        if (remappingFunction == null) {
            throw new NullPointerException("remappingFunction is marked non-null but is null");
        }
        this.playerOptions.computeIfAbsent(player, k -> Collections.synchronizedMap(new WeakHashMap())).replaceAll((k, v) -> {
            Object value = remappingFunction.apply(option, v);
            if (value == null) {
                value = option.getDefaultValue();
            }
            if (this.postEvent(option, player, value)) {
                return null;
            }
            if (!Objects.equals(v, value)) {
                this.postPacket(option, player, value);
            }
            return value;
        });
    }

    @Override
    @NonNull
    public Iterator<Option<?, ?, ?>> iterator() {
        return this.options.keySet().iterator();
    }

    public Value wrapValue(Value.Builder valueBuilder, Type type, @Nullable Object current) {
        if (current == null) {
            return valueBuilder.setNullValue(NullValue.NULL_VALUE).build();
        }
        Type boxed = GenericTypeReflector.box(type);
        Class<?> clazz = GenericTypeReflector.erase(boxed);
        if (clazz.isEnum()) {
            return valueBuilder.setStringValue(((Enum)current).name()).build();
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return valueBuilder.setNumberValue(((Number)current).doubleValue()).build();
        }
        if (String.class.isAssignableFrom(clazz)) {
            return valueBuilder.setStringValue((String)current).build();
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return valueBuilder.setBoolValue((Boolean)current).build();
        }
        if (List.class.isAssignableFrom(clazz)) {
            AnnotatedType elementType = this.elementType(boxed);
            ListValue.Builder listBuilder = ListValue.newBuilder();
            for (Object object : (List)current) {
                listBuilder.addValues(this.wrapValue(Value.newBuilder(), elementType.getType(), object));
            }
            return valueBuilder.setListValue(listBuilder.build()).build();
        }
        if (Color.class.isAssignableFrom(clazz)) {
            if (current instanceof String) {
                String string = (String)current;
                return valueBuilder.setStringValue(string).build();
            }
            if (current instanceof Color) {
                Color currentColor = (Color)current;
                return valueBuilder.setStringValue(Integer.toHexString(currentColor.getRGB())).build();
            }
            throw new RuntimeException("Unable to wrap Color value of type '" + clazz.getSimpleName() + "'!");
        }
        throw new RuntimeException("Unable to wrap value of type '" + clazz.getSimpleName() + "'!");
    }

    @Nullable
    public Object unwrapValue(Value wrapper, Type type) {
        if (wrapper.hasNullValue()) {
            return null;
        }
        Type boxed = GenericTypeReflector.box(type);
        Class<?> clazz = GenericTypeReflector.erase(boxed);
        if (clazz.isEnum() && wrapper.hasStringValue()) {
            return Enum.valueOf(clazz, wrapper.getStringValue());
        }
        if (Number.class.isAssignableFrom(clazz) && wrapper.hasNumberValue()) {
            return wrapper.getNumberValue();
        }
        if (String.class.isAssignableFrom(clazz) && wrapper.hasStringValue()) {
            return wrapper.getStringValue();
        }
        if (Boolean.class.isAssignableFrom(clazz) && wrapper.hasBoolValue()) {
            return wrapper.getBoolValue();
        }
        if (List.class.isAssignableFrom(clazz) && wrapper.hasListValue()) {
            AnnotatedType elementType = this.elementType(boxed);
            ListValue listValue = wrapper.getListValue();
            ArrayList<Object> list = new ArrayList<Object>(listValue.getValuesCount());
            for (int i = 0; i < listValue.getValuesCount(); ++i) {
                list.add(this.unwrapValue(listValue.getValues(i), elementType.getType()));
            }
            return Collections.unmodifiableList(list);
        }
        if (Color.class.isAssignableFrom(clazz) && wrapper.hasStringValue()) {
            return wrapper.getStringValue();
        }
        throw new RuntimeException("Unable to unwrap value of type '" + clazz.getSimpleName() + "'!");
    }

    protected boolean postEvent(Option<?, ?, ?> option, @Nullable ApolloPlayer player, @Nullable Object value) {
        EventBus.EventResult<ApolloUpdateOptionEvent> eventResult = EventBus.getBus().post(new ApolloUpdateOptionEvent(this, player, option, value));
        for (Throwable throwable : eventResult.getThrowing()) {
            throwable.printStackTrace();
        }
        return eventResult.getEvent().isCancelled();
    }

    protected void postPacket(Option<?, ?, ?> option, @Nullable ApolloPlayer player, @Nullable Object value) {
        if (!option.isNotify()) {
            return;
        }
        Collection<ApolloPlayer> players = player == null ? Apollo.getPlayerManager().getPlayers() : Collections.singleton(player);
        Value valueWrapper = this.wrapValue(Value.newBuilder(), option.getTypeToken().getType(), value);
        NetworkOptions.sendOption(this.module, option, valueWrapper, players);
    }

    private AnnotatedType elementType(Type type) {
        AnnotatedType elementType = GenericTypeReflector.annotate(type);
        if (!(elementType instanceof AnnotatedParameterizedType)) {
            throw new RuntimeException("Raw types for lists are not supported!");
        }
        return ((AnnotatedParameterizedType)elementType).getAnnotatedActualTypeArguments()[0];
    }
}

