/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.version;

import lombok.Generated;

public class ApolloVersion {
    private final int major;
    private final int minor;
    private final int patch;

    public ApolloVersion(String version) {
        String[] versions = version.replaceAll("[^0-9.]", "").split("\\.");
        if (versions.length != 3) {
            throw new RuntimeException("Failed to parse Apollo version.");
        }
        try {
            this.major = Integer.parseInt(versions[0]);
            this.minor = Integer.parseInt(versions[1]);
            this.patch = Integer.parseInt(versions[2]);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Failed to parse Apollo version.");
        }
    }

    public boolean isUpdateAvailable(ApolloVersion version) {
        if (version.getMajor() > this.major) {
            return true;
        }
        if (version.getMinor() > this.minor) {
            return true;
        }
        return version.getPatch() > this.patch;
    }

    @Generated
    public int getMajor() {
        return this.major;
    }

    @Generated
    public int getMinor() {
        return this.minor;
    }

    @Generated
    public int getPatch() {
        return this.patch;
    }
}

