/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.wrapper;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.ApolloFoliaPlatform;
import com.lunarclient.apollo.common.location.ApolloLocation;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.world.ApolloWorld;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public final class FoliaApolloPlayer
extends AbstractApolloPlayer {
    private final Player player;

    @Override
    public UUID getUniqueId() {
        return this.player.getUniqueId();
    }

    @Override
    public String getName() {
        return this.player.getName();
    }

    @Override
    public Optional<ApolloWorld> getWorld() {
        World world = this.player.getWorld();
        return Apollo.getWorldManager().getWorld(world.getName());
    }

    @Override
    public Optional<ApolloLocation> getLocation() {
        Location location = this.player.getLocation();
        return Optional.of(ApolloLocation.builder().world(location.getWorld().getName()).x(location.getX()).y(location.getY()).z(location.getZ()).build());
    }

    @Override
    public boolean hasPermission(String permissionNode) {
        return this.player.hasPermission(permissionNode);
    }

    @Override
    public void sendPacket(byte[] messages) {
        this.player.sendPluginMessage((Plugin)ApolloFoliaPlatform.getInstance(), "lunar:apollo", messages);
    }

    @Override
    @NotNull
    public Audience audience() {
        return this.player;
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public FoliaApolloPlayer(Player player) {
        this.player = player;
    }
}

