/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.wrapper;

import com.lunarclient.apollo.stats.ApolloPluginDescription;
import com.lunarclient.apollo.stats.ApolloStats;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class FoliaApolloStats
implements ApolloStats {
    @Override
    public boolean isOnlineMode() {
        return Bukkit.getServer().getOnlineMode();
    }

    @Override
    public String getIcon() {
        BufferedImage image;
        File icon = new File(new File("."), "server-icon.png");
        if (!icon.isFile()) {
            return null;
        }
        try {
            image = ImageIO.read(icon);
        }
        catch (IOException e) {
            return null;
        }
        if (image.getWidth() != 64 || image.getHeight() != 64) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "PNG", outputStream);
        }
        catch (IOException e) {
            return null;
        }
        byte[] bytes = outputStream.toByteArray();
        return Base64.getEncoder().encodeToString(bytes);
    }

    @Override
    public String getVersion() {
        return Bukkit.getServer().getBukkitVersion();
    }

    @Override
    public List<ApolloPluginDescription> getPlugins() {
        return Arrays.stream(Bukkit.getPluginManager().getPlugins()).map(Plugin::getDescription).map(description -> ApolloPluginDescription.builder().name(description.getName()).description(description.getDescription()).authors(description.getAuthors()).version(description.getVersion()).build()).collect(Collectors.toList());
    }

    @Override
    public String getPlatformSubtype() {
        return "Folia";
    }

    @Override
    public String getPlatformVersion() {
        return Bukkit.getServer().getVersion();
    }

    @Override
    public int getTotalPlayers() {
        return Bukkit.getOnlinePlayers().size();
    }
}

