/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.event;

import com.lunarclient.apollo.event.Event;
import com.lunarclient.apollo.event.Listen;
import com.lunarclient.apollo.event.ReflectiveConsumer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

public final class EventBus {
    private static final EventBus bus = new EventBus();
    private final Map<Class<? extends Event>, CopyOnWriteArrayList<Consumer<? extends Event>>> events = new ConcurrentHashMap<Class<? extends Event>, CopyOnWriteArrayList<Consumer<? extends Event>>>();

    public void register(@NonNull Object instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        for (Method method : this.getEventMethods(instance)) {
            this.events.computeIfAbsent(method.getParameterTypes()[0], k -> new CopyOnWriteArrayList()).add(new ReflectiveConsumer(instance, method));
        }
    }

    public <T extends Event> boolean register(@NonNull Class<T> event, @NonNull Consumer<T> consumer) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return this.events.computeIfAbsent(event, key -> new CopyOnWriteArrayList()).add(consumer);
    }

    public void unregister(@NonNull Object instance) {
        if (instance == null) {
            throw new NullPointerException("instance is marked non-null but is null");
        }
        for (Method method : this.getEventMethods(instance)) {
            List listeners = this.events.get(method.getParameterTypes()[0]);
            if (listeners == null) continue;
            listeners.removeIf(consumer -> consumer instanceof ReflectiveConsumer && ((ReflectiveConsumer)consumer).getInstance() == instance);
        }
    }

    public <T extends Event> boolean unregister(@NonNull Class<T> event, @NonNull Consumer<T> consumer) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        CopyOnWriteArrayList<Consumer<? extends Event>> consumers = this.events.get(event);
        return consumers != null && consumers.remove(consumer);
    }

    public <T extends Event> EventResult<T> post(@NonNull T event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        CopyOnWriteArrayList<Consumer<? extends Event>> consumers = this.events.get(event.getClass());
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        if (consumers != null) {
            for (Consumer<? extends Event> consumer : consumers) {
                try {
                    consumer.accept(event);
                }
                catch (Throwable throwable) {
                    throwables.add(throwable);
                }
            }
        }
        return new EventResult<T>(event, throwables);
    }

    private List<Method> getEventMethods(Object instance) {
        return Arrays.stream(instance.getClass().getDeclaredMethods()).filter(method -> method.isAnnotationPresent(Listen.class) && method.getParameterCount() == 1 && Event.class.isAssignableFrom(method.getParameterTypes()[0])).collect(Collectors.toList());
    }

    @Generated
    private EventBus() {
    }

    @Generated
    public static EventBus getBus() {
        return bus;
    }

    public static final class EventResult<T extends Event> {
        private final T event;
        private final List<Throwable> throwing;

        @Generated
        public EventResult(T event, List<Throwable> throwing) {
            this.event = event;
            this.throwing = throwing;
        }

        @Generated
        public T getEvent() {
            return this.event;
        }

        @Generated
        public List<Throwable> getThrowing() {
            return this.throwing;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventResult)) {
                return false;
            }
            EventResult other = (EventResult)o;
            T this$event = this.getEvent();
            T other$event = other.getEvent();
            if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
                return false;
            }
            List<Throwable> this$throwing = this.getThrowing();
            List<Throwable> other$throwing = other.getThrowing();
            return !(this$throwing == null ? other$throwing != null : !((Object)this$throwing).equals(other$throwing));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : $event.hashCode());
            List<Throwable> $throwing = this.getThrowing();
            result = result * 59 + ($throwing == null ? 43 : ((Object)$throwing).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EventBus.EventResult(event=" + this.getEvent() + ", throwing=" + this.getThrowing() + ")";
        }
    }
}

