/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.libs.configurate.loader;

import com.lunarclient.apollo.libs.configurate.ConfigurationNode;
import com.lunarclient.apollo.libs.configurate.loader.LoaderOptionSources;
import com.lunarclient.apollo.libs.configurate.serialize.Scalars;
import com.lunarclient.apollo.libs.configurate.serialize.SerializationException;
import java.util.Arrays;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface LoaderOptionSource {
    public static LoaderOptionSource environmentVariables() {
        return LoaderOptionSources.ENVIRONMENT;
    }

    public static LoaderOptionSource environmentVariables(String prefix) {
        return new LoaderOptionSources.EnvironmentVariables(Objects.requireNonNull(prefix, "prefix"));
    }

    public static LoaderOptionSource systemProperties() {
        return LoaderOptionSources.SYSTEM_PROPERTIES;
    }

    public static LoaderOptionSource systemProperties(String prefix) {
        return new LoaderOptionSources.SystemProperties(Objects.requireNonNull(prefix, "prefix"));
    }

    public static LoaderOptionSource node(ConfigurationNode node) {
        return new LoaderOptionSources.Node(Objects.requireNonNull(node, "node"));
    }

    public static LoaderOptionSource composite(LoaderOptionSource ... sources) {
        return new LoaderOptionSources.Composite(Arrays.copyOf(sources, sources.length));
    }

    public @Nullable String get(String ... var1);

    default public String getOr(String defaultValue, String ... path) {
        @Nullable String value = this.get(path);
        return value == null ? defaultValue : value;
    }

    default public <T extends Enum<T>> @Nullable T getEnum(Class<T> enumClazz, String ... path) {
        @Nullable String value = this.get(path);
        try {
            return (T)(value == null ? null : Scalars.ENUM.deserialize(enumClazz, (Object)value));
        }
        catch (SerializationException e) {
            return null;
        }
    }

    default public <T extends Enum<T>> T getEnum(Class<T> enumClazz, T defaultValue, String ... path) {
        @Nullable T value = this.getEnum(enumClazz, path);
        return value == null ? defaultValue : value;
    }

    default public int getInt(int defaultValue, String ... path) {
        @Nullable String value = this.get(path);
        if (value == null) {
            return defaultValue;
        }
        @Nullable Integer attempt = Scalars.INTEGER.tryDeserialize(value);
        return attempt == null ? defaultValue : attempt;
    }

    default public double getDouble(double defaultValue, String ... path) {
        @Nullable String value = this.get(path);
        if (value == null) {
            return defaultValue;
        }
        @Nullable Double attempt = Scalars.DOUBLE.tryDeserialize(value);
        return attempt == null ? defaultValue : attempt;
    }

    default public boolean getBoolean(boolean defaultValue, String ... path) {
        @Nullable String value = this.get(path);
        if (value == null) {
            return defaultValue;
        }
        @Nullable Boolean attempt = Scalars.BOOLEAN.tryDeserialize(value);
        return attempt == null ? defaultValue : attempt;
    }
}

