/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.listener;

import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.metadata.FoliaMetadataManager;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ApolloMetadataListener
implements Listener {
    private final JavaPlugin plugin;

    public ApolloMetadataListener(JavaPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    private void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this.plugin, t -> {
            if (!player.isOnline()) {
                return;
            }
            String brand = player.getClientBrandName();
            if (brand == null) {
                return;
            }
            FoliaMetadataManager manager = (FoliaMetadataManager)ApolloManager.getMetadataManager();
            manager.getClientBrands().add(brand);
        }, 60L);
    }

    @EventHandler
    private void onResourcePackStatus(PlayerResourcePackStatusEvent event) {
        String status = event.getStatus().name();
        FoliaMetadataManager manager = (FoliaMetadataManager)ApolloManager.getMetadataManager();
        Map<String, Integer> statuses = manager.getResourcePackStatuses();
        statuses.put(status, statuses.getOrDefault(status, 0) + 1);
    }
}

