/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.listener;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.event.ApolloListener;
import com.lunarclient.apollo.event.ApolloReceivePacketEvent;
import com.lunarclient.apollo.event.EventBus;
import com.lunarclient.apollo.event.Listen;
import com.lunarclient.apollo.player.ApolloPlayerManagerImpl;
import com.lunarclient.apollo.player.v1.PlayerHandshakeMessage;
import com.lunarclient.apollo.version.ApolloVersionManager;
import com.lunarclient.apollo.wrapper.FoliaApolloPlayer;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRegisterChannelEvent;
import org.bukkit.event.player.PlayerUnregisterChannelEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ApolloPlayerListener
implements Listener,
ApolloListener {
    public ApolloPlayerListener(JavaPlugin plugin) {
        EventBus.getBus().register(this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    private void onRegisterChannel(PlayerRegisterChannelEvent event) {
        if (!event.getChannel().equalsIgnoreCase("lunar:apollo")) {
            return;
        }
        ((ApolloPlayerManagerImpl)Apollo.getPlayerManager()).addPlayer(new FoliaApolloPlayer(event.getPlayer()));
    }

    @EventHandler
    private void onUnregisterChannel(PlayerUnregisterChannelEvent event) {
        if (!event.getChannel().equalsIgnoreCase("lunar:apollo")) {
            return;
        }
        ((ApolloPlayerManagerImpl)Apollo.getPlayerManager()).removePlayer(event.getPlayer().getUniqueId());
    }

    @EventHandler
    private void onPlayerQuit(PlayerQuitEvent event) {
        ((ApolloPlayerManagerImpl)Apollo.getPlayerManager()).removePlayer(event.getPlayer().getUniqueId());
    }

    @EventHandler
    private void onPlayerJoin(PlayerJoinEvent event) {
        if (!ApolloVersionManager.NEEDS_UPDATE) {
            return;
        }
        Player player = event.getPlayer();
        if (player.isOp()) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "[Apollo] You're running an outdated version of Apollo. Use \"/apollo update\" to update to the latest version!");
        }
    }

    @Listen
    private void onApolloReceivePacket(ApolloReceivePacketEvent event) {
        event.unpack(PlayerHandshakeMessage.class).ifPresent(message -> ((ApolloPlayerManagerImpl)Apollo.getPlayerManager()).handlePlayerHandshake(event.getPlayer(), (PlayerHandshakeMessage)message));
    }
}

