/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.listener;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.event.ApolloListener;
import com.lunarclient.apollo.event.EventBus;
import com.lunarclient.apollo.event.Listen;
import com.lunarclient.apollo.event.player.ApolloRegisterPlayerEvent;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.player.ApolloPlayer;
import com.lunarclient.apollo.player.v1.UpdatePlayerWorldMessage;
import com.lunarclient.apollo.world.ApolloWorldManagerImpl;
import com.lunarclient.apollo.wrapper.FoliaApolloWorld;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class ApolloWorldListener
implements Listener,
ApolloListener {
    public ApolloWorldListener(JavaPlugin plugin) {
        EventBus.getBus().register(this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        ApolloWorldManagerImpl worldManager = (ApolloWorldManagerImpl)Apollo.getWorldManager();
        for (World world : Bukkit.getWorlds()) {
            worldManager.addWorld(new FoliaApolloWorld(world));
        }
    }

    @EventHandler
    private void onWorldLoad(WorldLoadEvent event) {
        ((ApolloWorldManagerImpl)Apollo.getWorldManager()).addWorld(new FoliaApolloWorld(event.getWorld()));
    }

    @EventHandler
    private void onWorldUnload(WorldUnloadEvent event) {
        ((ApolloWorldManagerImpl)Apollo.getWorldManager()).removeWorld(event.getWorld().getName());
    }

    @EventHandler
    private void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        Player player = event.getPlayer();
        Apollo.getPlayerManager().getPlayer(player.getUniqueId()).ifPresent(apolloPlayer -> {
            UpdatePlayerWorldMessage message = UpdatePlayerWorldMessage.newBuilder().setWorld(player.getWorld().getName()).build();
            ((AbstractApolloPlayer)apolloPlayer).sendPacket(message);
        });
    }

    @Listen
    private void onApolloRegisterPlayer(ApolloRegisterPlayerEvent event) {
        ApolloPlayer apolloPlayer = event.getPlayer();
        apolloPlayer.getWorld().ifPresent(world -> {
            UpdatePlayerWorldMessage message = UpdatePlayerWorldMessage.newBuilder().setWorld(world.getName()).build();
            ((AbstractApolloPlayer)apolloPlayer).sendPacket(message);
        });
    }
}

