/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.packetenrichment;

import com.lunarclient.apollo.event.ApolloReceivePacketEvent;
import com.lunarclient.apollo.event.EventBus;
import com.lunarclient.apollo.event.packetenrichment.chat.ApolloPlayerChatCloseEvent;
import com.lunarclient.apollo.event.packetenrichment.chat.ApolloPlayerChatOpenEvent;
import com.lunarclient.apollo.event.packetenrichment.melee.ApolloPlayerAttackEvent;
import com.lunarclient.apollo.event.packetenrichment.world.ApolloPlayerUseItemEvent;
import com.lunarclient.apollo.module.packetenrichment.PacketEnrichmentModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.packetenrichment.v1.PlayerAttackMessage;
import com.lunarclient.apollo.packetenrichment.v1.PlayerChatCloseMessage;
import com.lunarclient.apollo.packetenrichment.v1.PlayerChatOpenMessage;
import com.lunarclient.apollo.packetenrichment.v1.PlayerUseItemMessage;

public final class PacketEnrichmentImpl
extends PacketEnrichmentModule {
    public PacketEnrichmentImpl() {
        this.handle(ApolloReceivePacketEvent.class, this::onReceivePacket);
    }

    private void onReceivePacket(ApolloReceivePacketEvent event) {
        event.unpack(PlayerAttackMessage.class).ifPresent(packet -> {
            ApolloPlayerAttackEvent playerAttackEvent = new ApolloPlayerAttackEvent(event.getPlayer(), NetworkTypes.fromProtobuf(packet.getPacketInfo().getInstantiationTime()), NetworkTypes.fromProtobuf(packet.getTargetInfo()), NetworkTypes.fromProtobuf(packet.getAttackerInfo()), packet.getDistance());
            EventBus.EventResult<ApolloPlayerAttackEvent> result = EventBus.getBus().post(playerAttackEvent);
            for (Throwable throwable : result.getThrowing()) {
                throwable.printStackTrace();
            }
        });
        event.unpack(PlayerChatOpenMessage.class).ifPresent(packet -> {
            ApolloPlayerChatOpenEvent playerChatOpenEvent = new ApolloPlayerChatOpenEvent(event.getPlayer(), NetworkTypes.fromProtobuf(packet.getPacketInfo().getInstantiationTime()), NetworkTypes.fromProtobuf(packet.getPlayerInfo()));
            EventBus.EventResult<ApolloPlayerChatOpenEvent> result = EventBus.getBus().post(playerChatOpenEvent);
            for (Throwable throwable : result.getThrowing()) {
                throwable.printStackTrace();
            }
        });
        event.unpack(PlayerChatCloseMessage.class).ifPresent(packet -> {
            ApolloPlayerChatCloseEvent playerChatCloseEvent = new ApolloPlayerChatCloseEvent(event.getPlayer(), NetworkTypes.fromProtobuf(packet.getPacketInfo().getInstantiationTime()), NetworkTypes.fromProtobuf(packet.getPlayerInfo()));
            EventBus.EventResult<ApolloPlayerChatCloseEvent> result = EventBus.getBus().post(playerChatCloseEvent);
            for (Throwable throwable : result.getThrowing()) {
                throwable.printStackTrace();
            }
        });
        event.unpack(PlayerUseItemMessage.class).ifPresent(packet -> {
            ApolloPlayerUseItemEvent playerUseItemEvent = new ApolloPlayerUseItemEvent(event.getPlayer(), NetworkTypes.fromProtobuf(packet.getPacketInfo().getInstantiationTime()), NetworkTypes.fromProtobuf(packet.getPlayerInfo()), packet.getMainHand());
            EventBus.EventResult<ApolloPlayerUseItemEvent> result = EventBus.getBus().post(playerUseItemEvent);
            for (Throwable throwable : result.getThrowing()) {
                throwable.printStackTrace();
            }
        });
    }
}

