/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.richpresence;

import com.lunarclient.apollo.module.richpresence.RichPresenceModule;
import com.lunarclient.apollo.module.richpresence.ServerRichPresence;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import com.lunarclient.apollo.richpresence.v1.OverrideServerRichPresenceMessage;
import com.lunarclient.apollo.richpresence.v1.ResetServerRichPresenceMessage;
import lombok.NonNull;

public final class RichPresenceModuleImpl
extends RichPresenceModule {
    @Override
    public void overrideServerRichPresence(@NonNull Recipients recipients, @NonNull ServerRichPresence richPresence) {
        String subServerName;
        String mapName;
        String playerState;
        String gameState;
        String gameVariantName;
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (richPresence == null) {
            throw new NullPointerException("richPresence is marked non-null but is null");
        }
        OverrideServerRichPresenceMessage.Builder builder = OverrideServerRichPresenceMessage.newBuilder().setTeamCurrentSize(richPresence.getTeamCurrentSize()).setTeamMaxSize(richPresence.getTeamMaxSize());
        String gameName = richPresence.getGameName();
        if (gameName != null) {
            builder.setGameName(gameName);
        }
        if ((gameVariantName = richPresence.getGameVariantName()) != null) {
            builder.setGameVariantName(gameVariantName);
        }
        if ((gameState = richPresence.getGameState()) != null) {
            builder.setGameState(gameState);
        }
        if ((playerState = richPresence.getPlayerState()) != null) {
            builder.setPlayerState(playerState);
        }
        if ((mapName = richPresence.getMapName()) != null) {
            builder.setMapName(mapName);
        }
        if ((subServerName = richPresence.getSubServerName()) != null) {
            builder.setSubServer(subServerName);
        }
        OverrideServerRichPresenceMessage message = builder.build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetServerRichPresence(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetServerRichPresenceMessage message = ResetServerRichPresenceMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

