/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.title;

import com.lunarclient.apollo.common.ApolloComponent;
import com.lunarclient.apollo.module.title.Title;
import com.lunarclient.apollo.module.title.TitleModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import com.lunarclient.apollo.title.v1.DisplayTitleMessage;
import com.lunarclient.apollo.title.v1.ResetTitlesMessage;
import com.lunarclient.apollo.title.v1.TitleType;
import com.lunarclient.apollo.util.Ranges;
import lombok.NonNull;

public final class TitleModuleImpl
extends TitleModule {
    @Override
    public void displayTitle(@NonNull Recipients recipients, @NonNull Title title) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        DisplayTitleMessage message = DisplayTitleMessage.newBuilder().setTitleType(TitleType.forNumber(title.getType().ordinal() + 1)).setAdventureJsonMessage(ApolloComponent.toJson(title.getMessage())).setScale(Ranges.checkPositive(title.getScale(), "Title#scale")).setFadeInTime(NetworkTypes.toProtobuf(title.getFadeInTime())).setDisplayTime(NetworkTypes.toProtobuf(title.getDisplayTime())).setFadeOutTime(NetworkTypes.toProtobuf(title.getFadeOutTime())).setInterpolationScale(Ranges.checkPositive(title.getInterpolationScale(), "Title#interpolationScale")).setInterpolationRate(Ranges.checkPositive(title.getInterpolationRate(), "Title#interpolationRate")).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetTitles(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetTitlesMessage message = ResetTitlesMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

