/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.network;

import com.lunarclient.apollo.common.ApolloEntity;
import com.lunarclient.apollo.common.cuboid.Cuboid2D;
import com.lunarclient.apollo.common.cuboid.Cuboid3D;
import com.lunarclient.apollo.common.icon.AdvancedResourceLocationIcon;
import com.lunarclient.apollo.common.icon.ItemStackIcon;
import com.lunarclient.apollo.common.location.ApolloBlockLocation;
import com.lunarclient.apollo.common.location.ApolloLocation;
import com.lunarclient.apollo.common.location.ApolloPlayerLocation;
import com.lunarclient.apollo.common.v1.BlockLocation;
import com.lunarclient.apollo.common.v1.Color;
import com.lunarclient.apollo.common.v1.EntityId;
import com.lunarclient.apollo.common.v1.Icon;
import com.lunarclient.apollo.common.v1.ItemStackIcon;
import com.lunarclient.apollo.common.v1.Location;
import com.lunarclient.apollo.common.v1.PlayerLocation;
import com.lunarclient.apollo.common.v1.SimpleResourceLocationIcon;
import com.lunarclient.apollo.common.v1.Uuid;
import com.lunarclient.apollo.libs.protobuf.Duration;
import com.lunarclient.apollo.libs.protobuf.Timestamp;
import com.lunarclient.apollo.module.packetenrichment.PlayerInfo;
import com.lunarclient.apollo.util.Ranges;
import java.util.UUID;

public final class NetworkTypes {
    public static EntityId toProtobuf(ApolloEntity object) {
        return EntityId.newBuilder().setEntityId(object.getEntityId()).setEntityUuid(NetworkTypes.toProtobuf(object.getEntityUuid())).build();
    }

    public static ApolloEntity fromProtobuf(EntityId message) {
        return new ApolloEntity(message.getEntityId(), NetworkTypes.fromProtobuf(message.getEntityUuid()));
    }

    public static Uuid toProtobuf(UUID object) {
        return Uuid.newBuilder().setHigh64(object.getMostSignificantBits()).setLow64(object.getLeastSignificantBits()).build();
    }

    public static UUID fromProtobuf(Uuid message) {
        return new UUID(message.getHigh64(), message.getLow64());
    }

    public static Color toProtobuf(java.awt.Color object) {
        return Color.newBuilder().setColor(object.getRGB()).build();
    }

    public static java.awt.Color fromProtobuf(Color message) {
        return new java.awt.Color(message.getColor());
    }

    public static Duration toProtobuf(java.time.Duration object) {
        return Duration.newBuilder().setSeconds(object.getSeconds()).setNanos(object.getNano()).build();
    }

    public static java.time.Duration fromProtobuf(Duration message) {
        return java.time.Duration.ofSeconds(message.getSeconds()).withNanos(message.getNanos());
    }

    public static Timestamp toProtobuf(long millis) {
        return Timestamp.newBuilder().setSeconds(millis / 1000L).setNanos((int)(millis % 1000L * 1000000L)).build();
    }

    public static long fromProtobuf(Timestamp message) {
        return message.getSeconds() * 1000L + (long)(message.getNanos() / 1000000);
    }

    public static com.lunarclient.apollo.packetenrichment.v1.PlayerInfo toProtobuf(PlayerInfo object) {
        return com.lunarclient.apollo.packetenrichment.v1.PlayerInfo.newBuilder().setPlayerUuid(NetworkTypes.toProtobuf(object.getPlayerUuid())).setLocation(NetworkTypes.toProtobuf(object.getLocation())).setSprinting(object.isSprinting()).setSneaking(object.isSneaking()).setJumping(object.isJumping()).setForwardSpeed(object.getForwardSpeed()).setStrafeSpeed(object.getStrafeSpeed()).build();
    }

    public static PlayerInfo fromProtobuf(com.lunarclient.apollo.packetenrichment.v1.PlayerInfo message) {
        return PlayerInfo.builder().playerUuid(NetworkTypes.fromProtobuf(message.getPlayerUuid())).location(NetworkTypes.fromProtobuf(message.getLocation())).sneaking(message.getSneaking()).sprinting(message.getSprinting()).jumping(message.getJumping()).forwardSpeed(message.getForwardSpeed()).strafeSpeed(message.getStrafeSpeed()).build();
    }

    public static Location toProtobuf(ApolloLocation object) {
        return Location.newBuilder().setWorld(object.getWorld()).setX(object.getX()).setY(object.getY()).setZ(object.getZ()).build();
    }

    public static ApolloLocation fromProtobuf(Location message) {
        return ApolloLocation.builder().world(message.getWorld()).x(message.getX()).y(message.getY()).z(message.getZ()).build();
    }

    public static BlockLocation toProtobuf(ApolloBlockLocation object) {
        return BlockLocation.newBuilder().setWorld(object.getWorld()).setX(object.getX()).setY(object.getY()).setZ(object.getZ()).build();
    }

    public static ApolloBlockLocation fromProtobuf(BlockLocation message) {
        return ApolloBlockLocation.builder().world(message.getWorld()).x(message.getX()).y(message.getY()).z(message.getZ()).build();
    }

    public static PlayerLocation toProtobuf(ApolloPlayerLocation object) {
        return PlayerLocation.newBuilder().setLocation(NetworkTypes.toProtobuf(object.getLocation())).setYaw(object.getYaw()).setPitch(object.getPitch()).build();
    }

    public static ApolloPlayerLocation fromProtobuf(PlayerLocation message) {
        return ApolloPlayerLocation.builder().location(NetworkTypes.fromProtobuf(message.getLocation())).yaw(message.getYaw()).pitch(message.getPitch()).build();
    }

    public static com.lunarclient.apollo.common.v1.Cuboid2D toProtobuf(Cuboid2D object) {
        return com.lunarclient.apollo.common.v1.Cuboid2D.newBuilder().setMinX(object.getMinX()).setMinZ(object.getMinZ()).setMaxX(object.getMaxX()).setMaxZ(object.getMaxZ()).build();
    }

    public static Cuboid2D fromProtobuf(com.lunarclient.apollo.common.v1.Cuboid2D message) {
        return Cuboid2D.builder().minX(message.getMinX()).minZ(message.getMinZ()).maxX(message.getMaxX()).maxZ(message.getMaxZ()).build();
    }

    public static com.lunarclient.apollo.common.v1.Cuboid3D toProtobuf(Cuboid3D object) {
        return com.lunarclient.apollo.common.v1.Cuboid3D.newBuilder().setMinX(object.getMinX()).setMinY(object.getMinY()).setMinZ(object.getMinZ()).setMaxX(object.getMaxX()).setMaxY(object.getMaxY()).setMaxZ(object.getMaxZ()).build();
    }

    public static Cuboid3D fromProtobuf(com.lunarclient.apollo.common.v1.Cuboid3D message) {
        return Cuboid3D.builder().minX(message.getMinX()).minY(message.getMinY()).minZ(message.getMinZ()).maxX(message.getMaxX()).maxY(message.getMaxY()).maxZ(message.getMaxZ()).build();
    }

    public static Icon toProtobuf(com.lunarclient.apollo.common.icon.Icon icon) {
        Icon.Builder builder = Icon.newBuilder();
        if (icon instanceof ItemStackIcon) {
            ItemStackIcon item = (ItemStackIcon)icon;
            String itemName = item.getItemName();
            ItemStackIcon.Builder itemBuilder = com.lunarclient.apollo.common.v1.ItemStackIcon.newBuilder().setItemId(item.getItemId()).setCustomModelData(item.getCustomModelData());
            if (itemName != null) {
                itemBuilder.setItemName(itemName);
            }
            builder.setItemStack(itemBuilder.build());
        } else if (icon instanceof com.lunarclient.apollo.common.icon.SimpleResourceLocationIcon) {
            com.lunarclient.apollo.common.icon.SimpleResourceLocationIcon simple = (com.lunarclient.apollo.common.icon.SimpleResourceLocationIcon)icon;
            builder.setSimpleResourceLocation(SimpleResourceLocationIcon.newBuilder().setResourceLocation(simple.getResourceLocation()).setSize(Ranges.checkPositive(simple.getSize(), "SimpleResourceLocationIcon#size")).build());
        } else if (icon instanceof AdvancedResourceLocationIcon) {
            AdvancedResourceLocationIcon advanced = (AdvancedResourceLocationIcon)icon;
            builder.setAdvancedResourceLocation(com.lunarclient.apollo.common.v1.AdvancedResourceLocationIcon.newBuilder().setResourceLocation(advanced.getResourceLocation()).setWidth(Ranges.checkPositive(advanced.getWidth(), "AdvancedResourceLocationIcon#width")).setHeight(Ranges.checkPositive(advanced.getHeight(), "AdvancedResourceLocationIcon#height")).setMinU(Ranges.checkRange(advanced.getMinU(), 0.0f, 1.0f, "AdvancedResourceLocationIcon#minU")).setMaxU(Ranges.checkRange(advanced.getMaxU(), 0.0f, 1.0f, "AdvancedResourceLocationIcon#maxU")).setMinV(Ranges.checkRange(advanced.getMinV(), 0.0f, 1.0f, "AdvancedResourceLocationIcon#minV")).setMaxV(Ranges.checkRange(advanced.getMaxV(), 0.0f, 1.0f, "AdvancedResourceLocationIcon#maxV")).build());
        }
        return builder.build();
    }

    public static com.lunarclient.apollo.common.icon.Icon fromProtobuf(Icon icon) {
        if (icon.hasItemStack()) {
            com.lunarclient.apollo.common.v1.ItemStackIcon item = icon.getItemStack();
            return ItemStackIcon.builder().itemName(item.getItemName()).itemId(item.getItemId()).customModelData(item.getCustomModelData()).build();
        }
        if (icon.hasSimpleResourceLocation()) {
            SimpleResourceLocationIcon simple = icon.getSimpleResourceLocation();
            return com.lunarclient.apollo.common.icon.SimpleResourceLocationIcon.builder().resourceLocation(simple.getResourceLocation()).size(simple.getSize()).build();
        }
        if (icon.hasAdvancedResourceLocation()) {
            com.lunarclient.apollo.common.v1.AdvancedResourceLocationIcon advanced = icon.getAdvancedResourceLocation();
            return AdvancedResourceLocationIcon.builder().resourceLocation(advanced.getResourceLocation()).width(advanced.getWidth()).height(advanced.getHeight()).minU(advanced.getMinU()).maxU(advanced.getMaxU()).minV(advanced.getMinV()).maxV(advanced.getMaxV()).build();
        }
        return null;
    }

    private NetworkTypes() {
    }
}

