/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.option.config;

import com.lunarclient.apollo.libs.configurate.ConfigurationNode;
import com.lunarclient.apollo.libs.configurate.serialize.SerializationException;
import com.lunarclient.apollo.libs.configurate.serialize.TypeSerializer;
import com.lunarclient.apollo.option.config.Serializer;
import java.awt.Color;
import java.lang.reflect.Type;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CommonSerializers
implements Serializer {
    public CommonSerializers() {
        this.serializer(Color.class, new ColorSerializer());
    }

    private static final class ColorSerializer
    implements TypeSerializer<Color> {
        private ColorSerializer() {
        }

        @Override
        public Color deserialize(Type type, ConfigurationNode node) throws SerializationException {
            String value = node.getString();
            if (value == null || value.isEmpty()) {
                return null;
            }
            String stringValue = node.getString();
            if (stringValue.startsWith("#")) {
                stringValue = stringValue.substring(1);
            }
            if (stringValue.length() != 8) {
                throw new NumberFormatException("Invalid color string length: " + stringValue);
            }
            long rgba = Long.parseLong(stringValue, 16);
            int alpha = (int)(rgba >> 24 & 0xFFL);
            int red = (int)(rgba >> 16 & 0xFFL);
            int green = (int)(rgba >> 8 & 0xFFL);
            int blue = (int)(rgba & 0xFFL);
            return new Color(red, green, blue, alpha);
        }

        @Override
        public void serialize(Type type, @Nullable Color color, ConfigurationNode node) throws SerializationException {
            if (color == null) {
                node.set("#FFFFFF");
                return;
            }
            node.set(String.format("#%06X", 0xFFFFFF & color.getRGB()));
        }
    }
}

