/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.player;

import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.async.Future;
import com.lunarclient.apollo.async.future.UncertainFuture;
import com.lunarclient.apollo.client.mod.LunarClientMod;
import com.lunarclient.apollo.client.version.LunarClientVersion;
import com.lunarclient.apollo.client.version.MinecraftVersion;
import com.lunarclient.apollo.common.location.ApolloLocation;
import com.lunarclient.apollo.libs.protobuf.Any;
import com.lunarclient.apollo.libs.protobuf.Message;
import com.lunarclient.apollo.module.tebex.TebexEmbeddedCheckoutSupport;
import com.lunarclient.apollo.player.ApolloPlayer;
import com.lunarclient.apollo.roundtrip.ApolloRequest;
import com.lunarclient.apollo.roundtrip.ApolloResponse;
import com.lunarclient.apollo.world.ApolloWorld;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public abstract class AbstractApolloPlayer
implements ApolloPlayer {
    private MinecraftVersion minecraftVersion;
    private LunarClientVersion lunarClientVersion;
    private List<LunarClientMod> installedMods;
    private TebexEmbeddedCheckoutSupport tebexEmbeddedCheckoutSupport;

    @Override
    public Optional<ApolloWorld> getWorld() {
        return Optional.empty();
    }

    @Override
    public Optional<ApolloLocation> getLocation() {
        return Optional.empty();
    }

    public <T extends ApolloResponse> Future<T> sendRoundTripPacket(ApolloRequest<T> request, Message message) {
        this.sendPacket(message);
        UncertainFuture future = new UncertainFuture();
        ApolloManager.getRoundtripManager().registerListener(request, future);
        return future;
    }

    public void sendPacket(Message message) {
        ApolloManager.getNetworkManager().sendPacket(this, Any.pack(message));
    }

    public abstract void sendPacket(byte[] var1);

    @Override
    @Generated
    public MinecraftVersion getMinecraftVersion() {
        return this.minecraftVersion;
    }

    @Override
    @Generated
    public LunarClientVersion getLunarClientVersion() {
        return this.lunarClientVersion;
    }

    @Override
    @Generated
    public List<LunarClientMod> getInstalledMods() {
        return this.installedMods;
    }

    @Override
    @Generated
    public TebexEmbeddedCheckoutSupport getTebexEmbeddedCheckoutSupport() {
        return this.tebexEmbeddedCheckoutSupport;
    }

    @Generated
    public void setMinecraftVersion(MinecraftVersion minecraftVersion) {
        this.minecraftVersion = minecraftVersion;
    }

    @Generated
    public void setLunarClientVersion(LunarClientVersion lunarClientVersion) {
        this.lunarClientVersion = lunarClientVersion;
    }

    @Generated
    public void setInstalledMods(List<LunarClientMod> installedMods) {
        this.installedMods = installedMods;
    }

    @Generated
    public void setTebexEmbeddedCheckoutSupport(TebexEmbeddedCheckoutSupport tebexEmbeddedCheckoutSupport) {
        this.tebexEmbeddedCheckoutSupport = tebexEmbeddedCheckoutSupport;
    }
}

