/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.player;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.client.mod.LunarClientMod;
import com.lunarclient.apollo.client.mod.LunarClientModType;
import com.lunarclient.apollo.client.version.LunarClientVersion;
import com.lunarclient.apollo.client.version.MinecraftVersion;
import com.lunarclient.apollo.event.EventBus;
import com.lunarclient.apollo.event.player.ApolloPlayerHandshakeEvent;
import com.lunarclient.apollo.event.player.ApolloRegisterPlayerEvent;
import com.lunarclient.apollo.event.player.ApolloUnregisterPlayerEvent;
import com.lunarclient.apollo.module.tebex.TebexEmbeddedCheckoutSupport;
import com.lunarclient.apollo.network.NetworkOptions;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.player.ApolloPlayer;
import com.lunarclient.apollo.player.ApolloPlayerManager;
import com.lunarclient.apollo.player.v1.PlayerHandshakeMessage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public final class ApolloPlayerManagerImpl
implements ApolloPlayerManager {
    private final Map<UUID, ApolloPlayer> players = new HashMap<UUID, ApolloPlayer>();

    @Override
    public Optional<ApolloPlayer> getPlayer(@NonNull UUID playerIdentifier) {
        if (playerIdentifier == null) {
            throw new NullPointerException("playerIdentifier is marked non-null but is null");
        }
        return Optional.ofNullable(this.players.get(playerIdentifier));
    }

    @Override
    public Collection<ApolloPlayer> getPlayers() {
        return Collections.unmodifiableCollection(this.players.values());
    }

    public void addPlayer(@NonNull ApolloPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (this.players.putIfAbsent(player.getUniqueId(), player) == null) {
            NetworkOptions.sendOptions(Apollo.getModuleManager().getModules(), true, player);
            EventBus.EventResult<ApolloRegisterPlayerEvent> result = EventBus.getBus().post(new ApolloRegisterPlayerEvent(player));
            for (Throwable throwable : result.getThrowing()) {
                throwable.printStackTrace();
            }
        }
    }

    public void removePlayer(@NonNull UUID player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        ApolloPlayer apolloPlayer = this.players.remove(player);
        if (apolloPlayer != null) {
            EventBus.EventResult<ApolloUnregisterPlayerEvent> result = EventBus.getBus().post(new ApolloUnregisterPlayerEvent(apolloPlayer));
            for (Throwable throwable : result.getThrowing()) {
                throwable.printStackTrace();
            }
        }
    }

    public void handlePlayerHandshake(@NotNull ApolloPlayer player, @NotNull PlayerHandshakeMessage message) {
        TebexEmbeddedCheckoutSupport checkoutSupportType;
        MinecraftVersion minecraftVersion;
        try {
            minecraftVersion = MinecraftVersion.valueOf(message.getMinecraftVersion().getEnum().toUpperCase());
        }
        catch (IllegalArgumentException e) {
            minecraftVersion = MinecraftVersion.UNKNOWN;
        }
        LunarClientVersion lunarClientVersion = LunarClientVersion.builder().gitBranch(message.getLunarClientVersion().getGitBranch()).gitCommit(message.getLunarClientVersion().getGitCommit()).semVer(message.getLunarClientVersion().getSemver()).build();
        LunarClientModType[] modTypes = LunarClientModType.values();
        List<LunarClientMod> mods = message.getInstalledModsList().stream().map(mod -> LunarClientMod.builder().id(mod.getId()).displayName(mod.getName()).version(mod.getVersion()).type(modTypes[mod.getTypeValue() - 1]).build()).collect(Collectors.toList());
        try {
            checkoutSupportType = TebexEmbeddedCheckoutSupport.values()[message.getEmbeddedCheckoutSupportValue() - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            checkoutSupportType = TebexEmbeddedCheckoutSupport.UNSUPPORTED;
        }
        EventBus.EventResult<ApolloPlayerHandshakeEvent> result = EventBus.getBus().post(new ApolloPlayerHandshakeEvent(player, minecraftVersion, lunarClientVersion, mods, checkoutSupportType));
        for (Throwable throwable : result.getThrowing()) {
            throwable.printStackTrace();
        }
        AbstractApolloPlayer apolloPlayer = (AbstractApolloPlayer)player;
        apolloPlayer.setMinecraftVersion(minecraftVersion);
        apolloPlayer.setLunarClientVersion(lunarClientVersion);
        apolloPlayer.setInstalledMods(mods);
        apolloPlayer.setTebexEmbeddedCheckoutSupport(checkoutSupportType);
    }

    @Generated
    public ApolloPlayerManagerImpl() {
    }
}

