/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.world;

import com.lunarclient.apollo.world.ApolloWorld;
import com.lunarclient.apollo.world.ApolloWorldManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;

public final class ApolloWorldManagerImpl
implements ApolloWorldManager {
    private final Map<String, ApolloWorld> worlds = new HashMap<String, ApolloWorld>();

    @Override
    public Optional<ApolloWorld> getWorld(@NonNull String world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        return Optional.ofNullable(this.worlds.get(world));
    }

    @Override
    public Collection<ApolloWorld> getWorlds() {
        return Collections.unmodifiableCollection(this.worlds.values());
    }

    public void addWorld(@NonNull ApolloWorld world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.worlds.putIfAbsent(world.getName(), world);
    }

    public void removeWorld(@NonNull String world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.worlds.remove(world);
    }

    @Generated
    public ApolloWorldManagerImpl() {
    }
}

