/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.loader;

import com.lunarclient.apollo.loader.PlatformPlugin;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;
import sun.misc.Unsafe;

public final class DynamicLoader {
    private static final Unsafe UNSAFE;
    private final URLClassLoader parent;
    private MethodHandle addURL;

    private static URL extractJar(ClassLoader loader, String resourcePath) {
        Path path;
        URL jarInJar = loader.getResource(resourcePath);
        if (jarInJar == null) {
            throw new RuntimeException("Unable to locate jar!");
        }
        try {
            path = Files.createTempFile("apollo-" + UUID.randomUUID().toString().substring(0, 8), ".jar.tmp", new FileAttribute[0]);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to create temporary jar!", exception);
        }
        path.toFile().deleteOnExit();
        try (InputStream inputStream = jarInJar.openStream();){
            Files.copy(inputStream, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to copy jar to temporary path!", exception);
        }
        try {
            return path.toUri().toURL();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to get url from temporary jar path!", exception);
        }
    }

    public DynamicLoader(@NonNull ClassLoader parent, @NonNull Logger logger) {
        if (parent == null) {
            throw new NullPointerException("parent is marked non-null but is null");
        }
        if (logger == null) {
            throw new NullPointerException("logger is marked non-null but is null");
        }
        if (!(parent instanceof URLClassLoader)) {
            throw new IllegalArgumentException("Parent class loader must be the plugin class loader!");
        }
        this.parent = (URLClassLoader)parent;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        try {
            Method targetMethod;
            block18: {
                targetMethod = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                try {
                    Class<?> moduleClass = Class.forName("java.lang.Module");
                    Field[] getModuleMethod = Class.class.getMethod("getModule", new Class[0]);
                    Method addOpensMethod = moduleClass.getMethod("addOpens", String.class, moduleClass);
                    Object classLoaderModule = getModuleMethod.invoke(URLClassLoader.class, new Object[0]);
                    Object thisModule = getModuleMethod.invoke(this.getClass(), new Object[0]);
                    addOpensMethod.invoke(classLoaderModule, URLClassLoader.class.getPackage().getName(), thisModule);
                }
                catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException exception) {
                    errors.add(exception);
                }
                try {
                    targetMethod.setAccessible(true);
                }
                catch (Exception exception) {
                    if (!exception.getClass().getName().endsWith("InaccessibleObjectException")) break block18;
                    if (UNSAFE != null) {
                        try {
                            for (Field trustedLookup : MethodHandles.Lookup.class.getDeclaredFields()) {
                                if (trustedLookup.getType() != MethodHandles.Lookup.class || !Modifier.isStatic(trustedLookup.getModifiers()) || trustedLookup.isSynthetic()) continue;
                                try {
                                    MethodHandles.Lookup lookup = (MethodHandles.Lookup)UNSAFE.getObject(UNSAFE.staticFieldBase(trustedLookup), UNSAFE.staticFieldOffset(trustedLookup));
                                    this.addURL = lookup.unreflect(targetMethod).bindTo(this.parent);
                                    return;
                                }
                                catch (Exception error) {
                                    errors.add(error);
                                }
                            }
                        }
                        catch (Exception error) {
                            errors.add(error);
                        }
                    }
                    try {
                        Class<?> agentClass = Class.forName("com.lunarclient.apollo.loader.DynamicAgent");
                        Class<?> instrumentationClass = Class.forName("java.lang.instrument.Instrumentation");
                        Object instrumentation = agentClass.getDeclaredMethod("getInstrumentation", new Class[0]).invoke(null, new Object[0]);
                        Method redefineModule = instrumentationClass.getDeclaredMethod("redefineModule", Class.forName("java.lang.Module"), Set.class, Map.class, Map.class, Set.class, Map.class);
                        Method getModule = Class.class.getDeclaredMethod("getModule", new Class[0]);
                        Map<String, Set<Object>> toOpen = Collections.singletonMap("java.net", Collections.singleton(getModule.invoke(this.getClass(), new Object[0])));
                        redefineModule.invoke(instrumentation, getModule.invoke(URLClassLoader.class, new Object[0]), Collections.emptySet(), Collections.emptyMap(), toOpen, Collections.emptySet(), Collections.emptyMap());
                        targetMethod.setAccessible(true);
                    }
                    catch (Exception error) {
                        errors.add(error);
                    }
                }
            }
            this.addURL = MethodHandles.lookup().unreflect(targetMethod).bindTo(this.parent);
            return;
        }
        catch (IllegalAccessException | NoSuchMethodException exception) {
            errors.add(exception);
            for (int i = errors.size() - 1; i > 0; --i) {
                logger.log(Level.SEVERE, "Unable to access plugin class loader!", (Throwable)errors.get(i));
            }
            return;
        }
    }

    public void install(@NonNull String[] resources) {
        if (resources == null) {
            throw new NullPointerException("resources is marked non-null but is null");
        }
        try {
            Arrays.stream(resources).map(resource -> DynamicLoader.extractJar(this.parent, resource)).forEach(this::loadJar);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to load library jars!", exception);
        }
    }

    public void loadJar(@NonNull URL url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            this.addURL.invokeWithArguments(url);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to load library jar!", throwable);
        }
    }

    public <T> PlatformPlugin createPlugin(Class<T> pluginLoaderType, T pluginLoaderInstance, String pluginClass) {
        Constructor<PlatformPlugin> constructor;
        Class<PlatformPlugin> plugin;
        try {
            plugin = Class.forName(pluginClass).asSubclass(PlatformPlugin.class);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("Unable to load plugin class!", exception);
        }
        try {
            constructor = plugin.getConstructor(pluginLoaderType);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("Unable to get plugin constructor!", exception);
        }
        try {
            return constructor.newInstance(pluginLoaderInstance);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("Unable to create plugin instance!", exception);
        }
    }

    static {
        Unsafe unsafe = null;
        for (Field field : Unsafe.class.getDeclaredFields()) {
            try {
                if (field.getType() != Unsafe.class || !Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                unsafe = (Unsafe)field.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        UNSAFE = unsafe;
    }
}

