/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.ApolloConfig;
import com.lunarclient.apollo.ApolloPlatform;
import com.lunarclient.apollo.api.ApolloHttpManager;
import com.lunarclient.apollo.libs.gson.Gson;
import com.lunarclient.apollo.libs.gson.GsonBuilder;
import com.lunarclient.apollo.module.ApolloModuleManagerImpl;
import com.lunarclient.apollo.network.ApolloNetworkManager;
import com.lunarclient.apollo.option.ConfigOptions;
import com.lunarclient.apollo.option.Option;
import com.lunarclient.apollo.option.config.CommonSerializers;
import com.lunarclient.apollo.player.ApolloPlayerManagerImpl;
import com.lunarclient.apollo.roundtrip.ApolloRoundtripManager;
import com.lunarclient.apollo.stats.ApolloStatsManager;
import com.lunarclient.apollo.stats.metadata.ApolloMetadataManager;
import com.lunarclient.apollo.util.ConfigTarget;
import com.lunarclient.apollo.version.ApolloVersionManager;
import com.lunarclient.apollo.world.ApolloWorldManagerImpl;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public final class ApolloManager {
    public static final String PLUGIN_MESSAGE_CHANNEL = "lunar:apollo";
    public static final String PLUGIN_ROOT_MODULE = "apollo";
    public static final Gson GSON = new GsonBuilder().create();
    private static final List<Option<?, ?, ?>> optionKeys = new LinkedList();
    private static ApolloPlatform platform;
    private static ApolloRoundtripManager roundtripManager;
    private static ApolloHttpManager httpManager;
    private static ApolloNetworkManager networkManager;
    private static ApolloVersionManager versionManager;
    private static ApolloStatsManager statsManager;
    private static ApolloMetadataManager metadataManager;
    private static Path configPath;
    private static boolean bootstrapped;

    public static void bootstrap(ApolloPlatform platform) {
        if (bootstrapped) {
            throw new IllegalStateException("Cannot bootstrap Apollo more than once!");
        }
        try {
            Apollo.initialize(platform, new ApolloModuleManagerImpl(), new ApolloWorldManagerImpl(), new ApolloPlayerManagerImpl());
            roundtripManager = new ApolloRoundtripManager();
            httpManager = new ApolloHttpManager();
            networkManager = new ApolloNetworkManager();
            versionManager = new ApolloVersionManager();
            statsManager = new ApolloStatsManager();
            new CommonSerializers();
            ApolloManager.platform = platform;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to bootstrap Apollo!", throwable);
        }
        bootstrapped = true;
    }

    public static void registerOptions(Option<?, ?, ?> ... options) {
        optionKeys.addAll(Arrays.asList(options));
    }

    public static void setConfigPath(Path path) {
        configPath = path;
    }

    public static void loadConfiguration() throws Throwable {
        for (ApolloConfig config : ApolloConfig.configs()) {
            config.reset();
        }
        ApolloConfig generalSettings = ApolloConfig.compute(configPath, ConfigTarget.GENERAL_SETTINGS);
        ConfigOptions.loadOptions(platform.getOptions(), generalSettings.node(), optionKeys);
    }

    public static void saveConfiguration() throws Throwable {
        ApolloConfig generalSettings = ApolloConfig.compute(configPath, ConfigTarget.GENERAL_SETTINGS);
        ConfigOptions.saveOptions(platform.getOptions(), generalSettings.node(), optionKeys);
        ((ApolloModuleManagerImpl)Apollo.getModuleManager()).saveConfiguration();
        for (ApolloConfig config : ApolloConfig.configs()) {
            config.save();
        }
    }

    private ApolloManager() {
    }

    @Generated
    public static ApolloRoundtripManager getRoundtripManager() {
        return roundtripManager;
    }

    @Generated
    public static ApolloHttpManager getHttpManager() {
        return httpManager;
    }

    @Generated
    public static ApolloNetworkManager getNetworkManager() {
        return networkManager;
    }

    @Generated
    public static ApolloVersionManager getVersionManager() {
        return versionManager;
    }

    @Generated
    public static ApolloStatsManager getStatsManager() {
        return statsManager;
    }

    @Generated
    public static ApolloMetadataManager getMetadataManager() {
        return metadataManager;
    }

    @Generated
    public static void setMetadataManager(ApolloMetadataManager metadataManager) {
        ApolloManager.metadataManager = metadataManager;
    }

    @Generated
    public static Path getConfigPath() {
        return configPath;
    }

    static {
        bootstrapped = false;
    }
}

