/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo;

import com.google.inject.Inject;
import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.ApolloPlatform;
import com.lunarclient.apollo.command.impl.ApolloCommand;
import com.lunarclient.apollo.command.impl.LunarClientCommand;
import com.lunarclient.apollo.listener.ApolloMetadataListener;
import com.lunarclient.apollo.listener.ApolloPlayerListener;
import com.lunarclient.apollo.metadata.VelocityMetadataManager;
import com.lunarclient.apollo.module.ApolloModuleManagerImpl;
import com.lunarclient.apollo.module.autotexthotkey.AutoTextHotkeyModule;
import com.lunarclient.apollo.module.beam.BeamModule;
import com.lunarclient.apollo.module.beam.BeamModuleImpl;
import com.lunarclient.apollo.module.border.BorderModule;
import com.lunarclient.apollo.module.border.BorderModuleImpl;
import com.lunarclient.apollo.module.chat.ChatModule;
import com.lunarclient.apollo.module.chat.ChatModuleImpl;
import com.lunarclient.apollo.module.coloredfire.ColoredFireModule;
import com.lunarclient.apollo.module.coloredfire.ColoredFireModuleImpl;
import com.lunarclient.apollo.module.combat.CombatModule;
import com.lunarclient.apollo.module.cooldown.CooldownModule;
import com.lunarclient.apollo.module.cooldown.CooldownModuleImpl;
import com.lunarclient.apollo.module.entity.EntityModule;
import com.lunarclient.apollo.module.entity.EntityModuleImpl;
import com.lunarclient.apollo.module.hologram.HologramModule;
import com.lunarclient.apollo.module.hologram.HologramModuleImpl;
import com.lunarclient.apollo.module.limb.LimbModule;
import com.lunarclient.apollo.module.limb.LimbModuleImpl;
import com.lunarclient.apollo.module.modsetting.ModSettingModule;
import com.lunarclient.apollo.module.nametag.NametagModule;
import com.lunarclient.apollo.module.nametag.NametagModuleImpl;
import com.lunarclient.apollo.module.notification.NotificationModule;
import com.lunarclient.apollo.module.notification.NotificationModuleImpl;
import com.lunarclient.apollo.module.richpresence.RichPresenceModule;
import com.lunarclient.apollo.module.richpresence.RichPresenceModuleImpl;
import com.lunarclient.apollo.module.serverrule.ServerRuleModule;
import com.lunarclient.apollo.module.staffmod.StaffModModule;
import com.lunarclient.apollo.module.staffmod.StaffModModuleImpl;
import com.lunarclient.apollo.module.stopwatch.StopwatchModule;
import com.lunarclient.apollo.module.stopwatch.StopwatchModuleImpl;
import com.lunarclient.apollo.module.team.TeamModule;
import com.lunarclient.apollo.module.team.TeamModuleImpl;
import com.lunarclient.apollo.module.tebex.TebexModule;
import com.lunarclient.apollo.module.tebex.TebexModuleImpl;
import com.lunarclient.apollo.module.title.TitleModule;
import com.lunarclient.apollo.module.title.TitleModuleImpl;
import com.lunarclient.apollo.module.transfer.TransferModule;
import com.lunarclient.apollo.module.transfer.TransferModuleImpl;
import com.lunarclient.apollo.module.vignette.VignetteModule;
import com.lunarclient.apollo.module.vignette.VignetteModuleImpl;
import com.lunarclient.apollo.module.waypoint.WaypointModule;
import com.lunarclient.apollo.module.waypoint.WaypointModuleImpl;
import com.lunarclient.apollo.option.Options;
import com.lunarclient.apollo.option.OptionsImpl;
import com.lunarclient.apollo.stats.ApolloStats;
import com.lunarclient.apollo.wrapper.VelocityApolloStats;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.ChannelRegistrar;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.Generated;

@Plugin(id="apollo", name="Apollo-Velocity", version="1.1.9", url="https://moonsworth.com", description="Implementation of Apollo for Velocity", authors={"Moonsworth"})
public final class ApolloVelocityPlatform
implements ApolloPlatform {
    public static MinecraftChannelIdentifier PLUGIN_CHANNEL = MinecraftChannelIdentifier.create((String)"lunar", (String)"apollo");
    private static ApolloVelocityPlatform instance;
    private final Options options = new OptionsImpl(null);
    private ApolloStats stats;
    private final ProxyServer server;
    private final Logger logger;
    private final Path dataDirectory;

    @Inject
    private ApolloVelocityPlatform(ProxyServer server, Logger logger, @DataDirectory Path dataDirectory) {
        this.server = server;
        this.logger = logger;
        this.dataDirectory = dataDirectory;
    }

    @Override
    public ApolloPlatform.Kind getKind() {
        return ApolloPlatform.Kind.PROXY;
    }

    @Override
    public String getApolloVersion() {
        return this.server.getPluginManager().fromInstance((Object)this).map(PluginContainer::getDescription).flatMap(PluginDescription::getVersion).orElse(null);
    }

    @Override
    public Logger getPlatformLogger() {
        return this.logger;
    }

    @Override
    public ApolloStats getStats() {
        return this.stats;
    }

    @Override
    public Object getPlugin() {
        return ApolloVelocityPlatform.getInstance();
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        instance = this;
        this.stats = new VelocityApolloStats();
        ApolloManager.bootstrap(this);
        ApolloManager.setMetadataManager(new VelocityMetadataManager());
        ((ApolloModuleManagerImpl)Apollo.getModuleManager()).addModule(AutoTextHotkeyModule.class).addModule(BeamModule.class, new BeamModuleImpl()).addModule(BorderModule.class, new BorderModuleImpl()).addModule(ChatModule.class, new ChatModuleImpl()).addModule(ColoredFireModule.class, new ColoredFireModuleImpl()).addModule(CombatModule.class).addModule(CooldownModule.class, new CooldownModuleImpl()).addModule(EntityModule.class, new EntityModuleImpl()).addModule(HologramModule.class, new HologramModuleImpl()).addModule(LimbModule.class, new LimbModuleImpl()).addModule(ModSettingModule.class).addModule(NametagModule.class, new NametagModuleImpl()).addModule(NotificationModule.class, new NotificationModuleImpl()).addModule(RichPresenceModule.class, new RichPresenceModuleImpl()).addModule(ServerRuleModule.class).addModule(StaffModModule.class, new StaffModModuleImpl()).addModule(StopwatchModule.class, new StopwatchModuleImpl()).addModule(TeamModule.class, new TeamModuleImpl()).addModule(TebexModule.class, new TebexModuleImpl()).addModule(TitleModule.class, new TitleModuleImpl()).addModule(TransferModule.class, new TransferModuleImpl()).addModule(VignetteModule.class, new VignetteModuleImpl()).addModule(WaypointModule.class, new WaypointModuleImpl());
        try {
            ApolloManager.setConfigPath(this.dataDirectory);
            ApolloManager.loadConfiguration();
            ((ApolloModuleManagerImpl)Apollo.getModuleManager()).enableModules();
            ApolloManager.saveConfiguration();
        }
        catch (Throwable throwable) {
            this.getPlatformLogger().log(Level.SEVERE, "Unable to load Apollo configuration and modules!", throwable);
        }
        EventManager eventManager = this.server.getEventManager();
        eventManager.register((Object)this, (Object)new ApolloMetadataListener());
        eventManager.register((Object)this, (Object)new ApolloPlayerListener());
        ChannelRegistrar channelRegistrar = this.server.getChannelRegistrar();
        channelRegistrar.register(new ChannelIdentifier[]{PLUGIN_CHANNEL});
        channelRegistrar.register(new ChannelIdentifier[]{ApolloMetadataListener.FML_HANDSHAKE_CHANNEL});
        CommandManager commandManager = this.server.getCommandManager();
        commandManager.register(ApolloCommand.create());
        commandManager.register(LunarClientCommand.create());
        ApolloManager.getStatsManager().enable();
        ApolloManager.getVersionManager().checkForUpdates();
    }

    @Subscribe
    public void onProxyShutdown(ProxyShutdownEvent event) {
        ((ApolloModuleManagerImpl)Apollo.getModuleManager()).disableModules();
    }

    @Override
    @Generated
    public Options getOptions() {
        return this.options;
    }

    @Generated
    public ProxyServer getServer() {
        return this.server;
    }

    @Generated
    public Logger getLogger() {
        return this.logger;
    }

    @Generated
    public Path getDataDirectory() {
        return this.dataDirectory;
    }

    @Generated
    public static ApolloVelocityPlatform getInstance() {
        return instance;
    }
}

