/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.common.ApolloEntity;
import com.lunarclient.apollo.common.location.ApolloBlockLocation;
import com.lunarclient.apollo.common.location.ApolloLocation;
import com.lunarclient.apollo.common.location.ApolloPlayerLocation;
import com.lunarclient.apollo.player.ApolloPlayer;
import com.lunarclient.apollo.player.ApolloPlayerManager;
import com.lunarclient.apollo.recipients.Recipients;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public final class FoliaApollo {
    public static void runForPlayer(@NonNull Player player, @NonNull Consumer<ApolloPlayer> playerConsumer) {
        FoliaApollo.runForPlayer(player.getUniqueId(), playerConsumer);
    }

    public static void runForPlayer(@NonNull UUID playerUuid, @NonNull Consumer<ApolloPlayer> playerConsumer) {
        Apollo.getPlayerManager().getPlayer(playerUuid).ifPresent(playerConsumer);
    }

    public static Recipients getRecipientsFrom(@NonNull Collection<Player> players) {
        ApolloPlayerManager playerManager = Apollo.getPlayerManager();
        List apolloPlayers = players.stream().map(player -> playerManager.getPlayer(player.getUniqueId())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return Recipients.of(apolloPlayers);
    }

    public static ApolloLocation toApolloLocation(@NonNull Location location) {
        return ApolloLocation.builder().world(location.getWorld().getName()).x(location.getX()).y(location.getY()).z(location.getZ()).build();
    }

    public static ApolloBlockLocation toApolloBlockLocation(@NonNull Location location) {
        return ApolloBlockLocation.builder().world(location.getWorld().getName()).x(location.getBlockX()).y(location.getBlockY()).z(location.getBlockZ()).build();
    }

    public static ApolloPlayerLocation toApolloPlayerLocation(@NonNull Location location) {
        return ApolloPlayerLocation.builder().location(FoliaApollo.toApolloLocation(location)).yaw(location.getYaw()).pitch(location.getPitch()).build();
    }

    public static ApolloEntity toApolloEntity(@NonNull Entity entity) {
        return new ApolloEntity(entity.getEntityId(), entity.getUniqueId());
    }

    public static Location toBukkitLocation(@NonNull ApolloLocation location) {
        return new Location(Bukkit.getWorld((String)location.getWorld()), location.getX(), location.getY(), location.getZ());
    }

    public static Location toBukkitLocation(@NonNull ApolloBlockLocation location) {
        return new Location(Bukkit.getWorld((String)location.getWorld()), (double)location.getX(), (double)location.getY(), (double)location.getZ());
    }

    public static Location toBukkitLocation(@NonNull ApolloPlayerLocation location) {
        ApolloLocation apolloLocation = location.getLocation();
        return new Location(Bukkit.getWorld((String)apolloLocation.getWorld()), apolloLocation.getX(), apolloLocation.getY(), apolloLocation.getZ(), location.getYaw(), location.getPitch());
    }

    private FoliaApollo() {
    }
}

