/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.command.impl;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.command.VelocityApolloCommand;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public final class LunarClientCommand
extends VelocityApolloCommand<CommandSource> {
    private final Command<CommandSource> playerCommand = context -> {
        String argument = (String)context.getArgument("player", String.class);
        CommandSource source = (CommandSource)context.getSource();
        this.handlePlayerArgument(source, argument, player -> {
            Component message = ((TextComponent)Component.text("Player ", (TextColor)NamedTextColor.GRAY).append(Component.text(player.getUsername(), (TextColor)NamedTextColor.AQUA))).append(Component.text(" is ", (TextColor)NamedTextColor.GRAY));
            message = Apollo.getPlayerManager().hasSupport(player.getUniqueId()) ? message.append(Component.text("using ", (TextColor)NamedTextColor.GREEN)) : message.append(Component.text("not using ", (TextColor)NamedTextColor.RED));
            message = message.append(Component.text("Lunar Client!", (TextColor)NamedTextColor.GRAY));
            this.textConsumer.accept(source, message);
        });
        return 1;
    };

    public static BrigadierCommand create() {
        LunarClientCommand command = new LunarClientCommand();
        return new BrigadierCommand(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"lunarclient").executes(source -> {
            command.sendCommandUsage((CommandSource)source.getSource());
            return 1;
        })).requires(source -> source.hasPermission("apollo.lunarclient"))).then((CommandNode)((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"player", (ArgumentType)StringArgumentType.word()).executes(command.getPlayerCommand())).build())).build());
    }

    LunarClientCommand() {
        super(Audience::sendMessage);
        this.setUsage("/lunarclient <player>");
    }

    @Generated
    public Command<CommandSource> getPlayerCommand() {
        return this.playerCommand;
    }
}

