/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.common;

import lombok.NonNull;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public final class ApolloComponent {
    public static Component fromJson(@NonNull String json) {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        return GsonComponentSerializer.gson().deserializeOrNull(json);
    }

    public static String toJson(@NonNull Component component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        return (String)GsonComponentSerializer.gson().serialize(component);
    }

    public static String toLegacy(@NonNull Component component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        return LegacyComponentSerializer.legacySection().serialize(component);
    }

    private ApolloComponent() {
    }
}

