/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.libs.configurate.loader;

import com.lunarclient.apollo.libs.configurate.BasicConfigurationNode;
import com.lunarclient.apollo.libs.configurate.ConfigurationNode;
import com.lunarclient.apollo.libs.configurate.loader.ConfigurationFormats;
import com.lunarclient.apollo.libs.configurate.loader.ConfigurationLoader;
import java.net.URL;
import java.nio.file.Path;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ConfigurationFormat {
    public static @Nullable ConfigurationFormat forExtension(String extension) {
        @Nullable ConfigurationFormats.Holder holder = ConfigurationFormats.BY_EXTENSION.get(extension);
        return holder == null ? null : holder.get();
    }

    public static Set<ConfigurationFormat> supportedFormats() {
        return ConfigurationFormats.unwrappedFormats();
    }

    public String id();

    public Set<String> supportedExtensions();

    default public ConfigurationLoader<@NonNull ?> create(Path file) {
        return this.create(file, (ConfigurationNode)BasicConfigurationNode.factory().createNode());
    }

    public ConfigurationLoader<@NonNull ?> create(Path var1, ConfigurationNode var2);

    default public ConfigurationLoader<@NonNull ?> create(URL url) {
        return this.create(url, (ConfigurationNode)BasicConfigurationNode.factory().createNode());
    }

    public ConfigurationLoader<@NonNull ?> create(URL var1, ConfigurationNode var2);
}

