/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.libs.configurate.loader;

import com.lunarclient.apollo.libs.configurate.loader.ConfigurationFormat;
import com.lunarclient.apollo.libs.configurate.util.UnmodifiableCollections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ConfigurationFormats {
    private static final boolean USE_OWN_CLASSLOADER;
    private static final String[] OWN_CLASSLOADER_SENTINEL_CLASSES;
    static final Map<String, Holder> BY_EXTENSION;
    static final Set<Holder> FORMATS;

    private ConfigurationFormats() {
    }

    static Set<ConfigurationFormat> unwrappedFormats() {
        return UnwrappedFormats.UNWRAPPED_FORMATS;
    }

    static {
        boolean useOwnLoader;
        OWN_CLASSLOADER_SENTINEL_CLASSES = new String[]{"org.bukkit.Bukkit"};
        String property = System.getProperty("configurate.services.discoverOnOwnClassloader");
        if (property != null) {
            useOwnLoader = Boolean.parseBoolean(property);
        } else {
            useOwnLoader = false;
            for (String clazz : OWN_CLASSLOADER_SENTINEL_CLASSES) {
                try {
                    Class.forName(clazz);
                    useOwnLoader = true;
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        USE_OWN_CLASSLOADER = useOwnLoader;
        HashMap<String, Holder> byExtension = new HashMap<String, Holder>();
        HashSet<Holder> formats = new HashSet<Holder>();
        ServiceLoader<ConfigurationFormat> loader = USE_OWN_CLASSLOADER ? ServiceLoader.load(ConfigurationFormat.class, ConfigurationFormats.class.getClassLoader()) : ServiceLoader.load(ConfigurationFormat.class);
        Iterator<ConfigurationFormat> it = loader.iterator();
        while (it.hasNext()) {
            ConfigurationFormat format;
            Holder holder;
            try {
                holder = new Holder(it.next());
            }
            catch (ServiceConfigurationError ex) {
                holder = new Holder(ex);
            }
            formats.add(holder);
            if (!holder.successful() || (format = holder.format) == null) continue;
            Set<String> supportedExtensions = Objects.requireNonNull(format.supportedExtensions(), () -> "The supported extensions field was improperly null on " + format);
            for (String ext : supportedExtensions) {
                byExtension.put(ext, holder);
            }
        }
        BY_EXTENSION = UnmodifiableCollections.copyOf(byExtension);
        FORMATS = UnmodifiableCollections.copyOf(formats);
    }

    static final class Holder {
        private final @Nullable ConfigurationFormat format;
        private final @Nullable ServiceConfigurationError error;

        Holder(ConfigurationFormat format) {
            this.format = format;
            this.error = null;
        }

        Holder(ServiceConfigurationError error) {
            this.format = null;
            this.error = error;
        }

        ConfigurationFormat get() {
            if (this.error != null) {
                throw this.error;
            }
            assert (this.format != null);
            return this.format;
        }

        boolean successful() {
            return this.format != null;
        }
    }

    static final class UnwrappedFormats {
        static final Set<ConfigurationFormat> UNWRAPPED_FORMATS;

        private UnwrappedFormats() {
        }

        static {
            HashSet<ConfigurationFormat> formats = new HashSet<ConfigurationFormat>(FORMATS.size());
            for (Holder format : FORMATS) {
                formats.add(format.get());
            }
            UNWRAPPED_FORMATS = UnmodifiableCollections.copyOf(formats);
        }
    }
}

