/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.libs.configurate.transformation;

import com.lunarclient.apollo.libs.configurate.ConfigurateException;
import com.lunarclient.apollo.libs.configurate.ConfigurationNode;
import com.lunarclient.apollo.libs.configurate.transformation.ConfigurationTransformation;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.Nullable;

class ChainedConfigurationTransformation
implements ConfigurationTransformation {
    private final ConfigurationTransformation[] transformations;

    ChainedConfigurationTransformation(ConfigurationTransformation[] transformations) {
        this.transformations = Arrays.copyOf(transformations, transformations.length);
    }

    @Override
    public void apply(ConfigurationNode node) throws ConfigurateException {
        @Nullable ConfigurateException thrown = null;
        for (ConfigurationTransformation transformation : this.transformations) {
            try {
                transformation.apply(node);
            }
            catch (ConfigurateException ex) {
                if (thrown == null) {
                    thrown = ex;
                    continue;
                }
                thrown.addSuppressed(ex);
            }
        }
        if (thrown != null) {
            throw thrown;
        }
    }
}

