/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.libs.configurate.yaml;

import com.lunarclient.apollo.libs.configurate.CommentedConfigurationNode;
import com.lunarclient.apollo.libs.configurate.ConfigurationNode;
import com.lunarclient.apollo.libs.configurate.ConfigurationOptions;
import com.lunarclient.apollo.libs.configurate.RepresentationHint;
import com.lunarclient.apollo.libs.configurate.loader.AbstractConfigurationLoader;
import com.lunarclient.apollo.libs.configurate.loader.CommentHandler;
import com.lunarclient.apollo.libs.configurate.loader.LoaderOptionSource;
import com.lunarclient.apollo.libs.configurate.util.UnmodifiableCollections;
import com.lunarclient.apollo.libs.configurate.yaml.NodeStyle;
import com.lunarclient.apollo.libs.configurate.yaml.ScalarStyle;
import com.lunarclient.apollo.libs.configurate.yaml.YamlCommentHandler;
import com.lunarclient.apollo.libs.configurate.yaml.YamlConstructor;
import com.lunarclient.apollo.libs.configurate.yaml.YamlRepresenter;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.DumperOptions;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.LoaderOptions;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.Yaml;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.constructor.BaseConstructor;
import com.lunarclient.apollo.libs.configurate.yaml.internal.snakeyaml.representer.Representer;
import java.io.BufferedReader;
import java.io.Writer;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class YamlConfigurationLoader
extends AbstractConfigurationLoader<CommentedConfigurationNode> {
    private static final Set<Class<?>> NATIVE_TYPES = UnmodifiableCollections.toSet(Boolean.class, Integer.class, Long.class, BigInteger.class, Double.class, byte[].class, String.class, java.util.Date.class, Date.class, Timestamp.class);
    public static final RepresentationHint<ScalarStyle> SCALAR_STYLE = RepresentationHint.of("configurate:yaml/scalarstyle", ScalarStyle.class);
    public static final RepresentationHint<NodeStyle> NODE_STYLE = RepresentationHint.of("configurate:yaml/nodestyle", NodeStyle.class);
    private final ThreadLocal<YamlConstructor> constructor;
    private final ThreadLocal<Yaml> yaml;

    public static Builder builder() {
        return new Builder();
    }

    private YamlConfigurationLoader(Builder builder) {
        super(builder, new CommentHandler[]{YamlCommentHandler.INSTANCE});
        LoaderOptions loaderOpts = new LoaderOptions().setAcceptTabs(true).setProcessComments(builder.commentsEnabled());
        loaderOpts.setCodePointLimit(Integer.MAX_VALUE);
        DumperOptions opts = builder.options;
        opts.setDefaultFlowStyle(NodeStyle.asSnakeYaml(builder.style));
        opts.setProcessComments(builder.commentsEnabled());
        opts.setWidth(builder.lineLength());
        opts.setIndicatorIndent(builder.sequenceIndent());
        opts.setIndentWithIndicator(true);
        this.constructor = ThreadLocal.withInitial(() -> new YamlConstructor(loaderOpts));
        this.yaml = ThreadLocal.withInitial(() -> new Yaml((BaseConstructor)this.constructor.get(), (Representer)new YamlRepresenter(true, opts), opts, loaderOpts));
    }

    @Override
    protected void loadInternal(CommentedConfigurationNode node, BufferedReader reader) {
        this.constructor.get().options = node.options();
        node.from((ConfigurationNode)this.yaml.get().load(reader));
    }

    @Override
    protected void saveInternal(ConfigurationNode node, Writer writer) {
        this.yaml.get().dump(node, writer);
    }

    @Override
    public CommentedConfigurationNode createNode(ConfigurationOptions options) {
        return CommentedConfigurationNode.root(options);
    }

    public static final class Builder
    extends AbstractConfigurationLoader.Builder<Builder, YamlConfigurationLoader> {
        private final DumperOptions options = new DumperOptions();
        private @Nullable NodeStyle style;
        private boolean enableComments;
        private int lineLength;

        Builder() {
            this.indent(4);
            this.sequenceIndent(0);
            this.defaultOptions(o -> o.nativeTypes(NATIVE_TYPES));
            this.from(DEFAULT_OPTIONS_SOURCE);
        }

        @Override
        protected void populate(LoaderOptionSource options) {
            @Nullable NodeStyle declared = options.getEnum(NodeStyle.class, "yaml", "node-style");
            if (declared != null) {
                this.style = declared;
            }
            this.enableComments = options.getBoolean(true, "yaml", "comments-enabled");
            this.lineLength = options.getInt(150, "yaml", "line-length");
        }

        public Builder indent(int indent) {
            this.options.setIndent(indent);
            return this;
        }

        public int indent() {
            return this.options.getIndent();
        }

        public Builder sequenceIndent(int indent) {
            this.options.setIndicatorIndent(indent);
            return this;
        }

        public int sequenceIndent() {
            return this.options.getIndicatorIndent();
        }

        public Builder nodeStyle(@Nullable NodeStyle style) {
            this.style = style;
            return this;
        }

        public @Nullable NodeStyle nodeStyle() {
            return this.style;
        }

        public Builder commentsEnabled(boolean enableComments) {
            this.enableComments = enableComments;
            return this;
        }

        public boolean commentsEnabled() {
            return this.enableComments;
        }

        public Builder lineLength(int lineLength) {
            this.lineLength = lineLength;
            return this;
        }

        public int lineLength() {
            return this.lineLength;
        }

        @Override
        public YamlConfigurationLoader build() {
            return new YamlConfigurationLoader(this);
        }
    }
}

