/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.beam;

import com.lunarclient.apollo.beam.v1.DisplayBeaconBeamMessage;
import com.lunarclient.apollo.beam.v1.RemoveBeaconBeamMessage;
import com.lunarclient.apollo.beam.v1.ResetBeaconBeamsMessage;
import com.lunarclient.apollo.module.beam.Beam;
import com.lunarclient.apollo.module.beam.BeamModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import lombok.NonNull;

public final class BeamModuleImpl
extends BeamModule {
    @Override
    public void displayBeam(@NonNull Recipients recipients, @NonNull Beam beam) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (beam == null) {
            throw new NullPointerException("beam is marked non-null but is null");
        }
        DisplayBeaconBeamMessage message = DisplayBeaconBeamMessage.newBuilder().setId(beam.getId()).setLocation(NetworkTypes.toProtobuf(beam.getLocation())).setColor(NetworkTypes.toProtobuf(beam.getColor())).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void removeBeam(@NonNull Recipients recipients, @NonNull String beamId) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (beamId == null) {
            throw new NullPointerException("beamId is marked non-null but is null");
        }
        RemoveBeaconBeamMessage message = RemoveBeaconBeamMessage.newBuilder().setId(beamId).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void removeBeam(@NonNull Recipients recipients, @NonNull Beam beam) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (beam == null) {
            throw new NullPointerException("beam is marked non-null but is null");
        }
        this.removeBeam(recipients, beam.getId());
    }

    @Override
    public void resetBeams(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetBeaconBeamsMessage message = ResetBeaconBeamsMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

