/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.border;

import com.lunarclient.apollo.border.v1.DisplayBorderMessage;
import com.lunarclient.apollo.border.v1.RemoveBorderMessage;
import com.lunarclient.apollo.border.v1.ResetBordersMessage;
import com.lunarclient.apollo.module.border.Border;
import com.lunarclient.apollo.module.border.BorderModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import com.lunarclient.apollo.util.Ranges;
import lombok.NonNull;

public final class BorderModuleImpl
extends BorderModule {
    @Override
    public void displayBorder(@NonNull Recipients recipients, @NonNull Border border) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (border == null) {
            throw new NullPointerException("border is marked non-null but is null");
        }
        DisplayBorderMessage message = DisplayBorderMessage.newBuilder().setId(border.getId()).setWorld(border.getWorld()).setCancelEntry(border.isCancelEntry()).setCancelExit(border.isCancelExit()).setCanShrinkOrExpand(border.isCanShrinkOrExpand()).setColor(NetworkTypes.toProtobuf(border.getColor())).setBounds(NetworkTypes.toProtobuf(border.getBounds())).setDurationTicks(Ranges.checkPositive(border.getDurationTicks(), "Border#durationTicks")).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void removeBorder(@NonNull Recipients recipients, @NonNull String borderId) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (borderId == null) {
            throw new NullPointerException("borderId is marked non-null but is null");
        }
        RemoveBorderMessage message = RemoveBorderMessage.newBuilder().setId(borderId).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void removeBorder(@NonNull Recipients recipients, @NonNull Border border) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (border == null) {
            throw new NullPointerException("border is marked non-null but is null");
        }
        this.removeBorder(recipients, border.getId());
    }

    @Override
    public void resetBorders(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetBordersMessage message = ResetBordersMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

