/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.coloredfire;

import com.lunarclient.apollo.coloredfire.v1.OverrideColoredFireMessage;
import com.lunarclient.apollo.coloredfire.v1.ResetColoredFireMessage;
import com.lunarclient.apollo.coloredfire.v1.ResetColoredFiresMessage;
import com.lunarclient.apollo.module.coloredfire.ColoredFireModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import java.awt.Color;
import java.util.UUID;
import lombok.NonNull;

public final class ColoredFireModuleImpl
extends ColoredFireModule {
    @Override
    public void overrideColoredFire(@NonNull Recipients recipients, @NonNull UUID burningPlayer, @NonNull Color color) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (burningPlayer == null) {
            throw new NullPointerException("burningPlayer is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        OverrideColoredFireMessage message = OverrideColoredFireMessage.newBuilder().setPlayerUuid(NetworkTypes.toProtobuf(burningPlayer)).setColor(NetworkTypes.toProtobuf(color)).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetColoredFire(@NonNull Recipients recipients, @NonNull UUID burningPlayer) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (burningPlayer == null) {
            throw new NullPointerException("burningPlayer is marked non-null but is null");
        }
        ResetColoredFireMessage message = ResetColoredFireMessage.newBuilder().setPlayerUuid(NetworkTypes.toProtobuf(burningPlayer)).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetColoredFires(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetColoredFiresMessage message = ResetColoredFiresMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

