/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.cooldown;

import com.lunarclient.apollo.cooldown.v1.DisplayCooldownMessage;
import com.lunarclient.apollo.cooldown.v1.RemoveCooldownMessage;
import com.lunarclient.apollo.cooldown.v1.ResetCooldownsMessage;
import com.lunarclient.apollo.module.cooldown.Cooldown;
import com.lunarclient.apollo.module.cooldown.CooldownModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import lombok.NonNull;

public final class CooldownModuleImpl
extends CooldownModule {
    @Override
    public void displayCooldown(@NonNull Recipients recipients, @NonNull Cooldown cooldown) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (cooldown == null) {
            throw new NullPointerException("cooldown is marked non-null but is null");
        }
        DisplayCooldownMessage message = DisplayCooldownMessage.newBuilder().setName(cooldown.getName()).setDuration(NetworkTypes.toProtobuf(cooldown.getDuration())).setIcon(NetworkTypes.toProtobuf(cooldown.getIcon())).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void removeCooldown(@NonNull Recipients recipients, @NonNull String cooldownName) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (cooldownName == null) {
            throw new NullPointerException("cooldownName is marked non-null but is null");
        }
        RemoveCooldownMessage message = RemoveCooldownMessage.newBuilder().setName(cooldownName).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void removeCooldown(@NonNull Recipients recipients, @NonNull Cooldown cooldown) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (cooldown == null) {
            throw new NullPointerException("cooldown is marked non-null but is null");
        }
        this.removeCooldown(recipients, cooldown.getName());
    }

    @Override
    public void resetCooldowns(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetCooldownsMessage message = ResetCooldownsMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

