/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.entity;

import com.lunarclient.apollo.common.ApolloEntity;
import com.lunarclient.apollo.entity.v1.FlipEntityMessage;
import com.lunarclient.apollo.entity.v1.OverrideRainbowSheepMessage;
import com.lunarclient.apollo.entity.v1.ResetFlipedEntityMessage;
import com.lunarclient.apollo.entity.v1.ResetRainbowSheepMessage;
import com.lunarclient.apollo.module.entity.EntityModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class EntityModuleImpl
extends EntityModule {
    @Override
    public void overrideRainbowSheep(@NonNull Recipients recipients, @NonNull List<ApolloEntity> sheepEntities) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (sheepEntities == null) {
            throw new NullPointerException("sheepEntities is marked non-null but is null");
        }
        Set sheepUuidsProto = sheepEntities.stream().map(NetworkTypes::toProtobuf).collect(Collectors.toSet());
        OverrideRainbowSheepMessage message = OverrideRainbowSheepMessage.newBuilder().addAllEntityIds(sheepUuidsProto).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetRainbowSheep(@NonNull Recipients recipients, @NonNull List<ApolloEntity> sheepEntities) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (sheepEntities == null) {
            throw new NullPointerException("sheepEntities is marked non-null but is null");
        }
        Set sheepUuidsProto = sheepEntities.stream().map(NetworkTypes::toProtobuf).collect(Collectors.toSet());
        ResetRainbowSheepMessage message = ResetRainbowSheepMessage.newBuilder().addAllEntityIds(sheepUuidsProto).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void flipEntity(@NonNull Recipients recipients, @NonNull List<ApolloEntity> entities) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        Set entityUuidsProto = entities.stream().map(NetworkTypes::toProtobuf).collect(Collectors.toSet());
        FlipEntityMessage message = FlipEntityMessage.newBuilder().addAllEntityIds(entityUuidsProto).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetFlippedEntity(@NonNull Recipients recipients, @NonNull List<ApolloEntity> entities) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (entities == null) {
            throw new NullPointerException("entities is marked non-null but is null");
        }
        Set entityUuidsProto = entities.stream().map(NetworkTypes::toProtobuf).collect(Collectors.toSet());
        ResetFlipedEntityMessage message = ResetFlipedEntityMessage.newBuilder().addAllEntityIds(entityUuidsProto).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

