/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.glow;

import com.lunarclient.apollo.glow.v1.OverrideGlowEffectMessage;
import com.lunarclient.apollo.glow.v1.ResetGlowEffectMessage;
import com.lunarclient.apollo.glow.v1.ResetGlowEffectsMessage;
import com.lunarclient.apollo.module.glow.GlowModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import java.awt.Color;
import java.util.UUID;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public final class GlowModuleImpl
extends GlowModule {
    @Override
    public void overrideGlow(@NonNull Recipients recipients, @NonNull UUID glowingPlayer) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (glowingPlayer == null) {
            throw new NullPointerException("glowingPlayer is marked non-null but is null");
        }
        this.overrideGlow(recipients, glowingPlayer, null);
    }

    @Override
    public void overrideGlow(@NonNull Recipients recipients, @NonNull UUID glowingPlayer, @Nullable Color color) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (glowingPlayer == null) {
            throw new NullPointerException("glowingPlayer is marked non-null but is null");
        }
        OverrideGlowEffectMessage.Builder builder = OverrideGlowEffectMessage.newBuilder().setPlayerUuid(NetworkTypes.toProtobuf(glowingPlayer));
        if (color != null) {
            builder.setColor(NetworkTypes.toProtobuf(color));
        }
        OverrideGlowEffectMessage message = builder.build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetGlow(@NonNull Recipients recipients, @NonNull UUID glowingPlayer) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (glowingPlayer == null) {
            throw new NullPointerException("glowingPlayer is marked non-null but is null");
        }
        ResetGlowEffectMessage message = ResetGlowEffectMessage.newBuilder().setPlayerUuid(NetworkTypes.toProtobuf(glowingPlayer)).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetGlow(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetGlowEffectsMessage message = ResetGlowEffectsMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

