/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.hologram;

import com.lunarclient.apollo.common.ApolloComponent;
import com.lunarclient.apollo.hologram.v1.DisplayHologramMessage;
import com.lunarclient.apollo.hologram.v1.RemoveHologramMessage;
import com.lunarclient.apollo.hologram.v1.ResetHologramsMessage;
import com.lunarclient.apollo.module.hologram.Hologram;
import com.lunarclient.apollo.module.hologram.HologramModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class HologramModuleImpl
extends HologramModule {
    @Override
    public void displayHologram(@NonNull Recipients recipients, @NonNull Hologram hologram) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (hologram == null) {
            throw new NullPointerException("hologram is marked non-null but is null");
        }
        DisplayHologramMessage message = DisplayHologramMessage.newBuilder().setId(hologram.getId()).setLocation(NetworkTypes.toProtobuf(hologram.getLocation())).addAllAdventureJsonLines(hologram.getLines().stream().map(ApolloComponent::toJson).collect(Collectors.toList())).setShowThroughWalls(hologram.isShowThroughWalls()).setShowShadow(hologram.isShowShadow()).setShowBackground(hologram.isShowBackground()).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void removeHologram(@NonNull Recipients recipients, @NonNull String hologramId) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (hologramId == null) {
            throw new NullPointerException("hologramId is marked non-null but is null");
        }
        RemoveHologramMessage message = RemoveHologramMessage.newBuilder().setId(hologramId).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void removeHologram(@NonNull Recipients recipients, @NonNull Hologram hologram) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (hologram == null) {
            throw new NullPointerException("hologram is marked non-null but is null");
        }
        this.removeHologram(recipients, hologram.getId());
    }

    @Override
    public void resetHolograms(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetHologramsMessage message = ResetHologramsMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

