/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.limb;

import com.lunarclient.apollo.limb.v1.HideArmorPiecesMessage;
import com.lunarclient.apollo.limb.v1.HideBodyPartMessage;
import com.lunarclient.apollo.limb.v1.ResetArmorPiecesMessage;
import com.lunarclient.apollo.limb.v1.ResetBodyPartMessage;
import com.lunarclient.apollo.module.limb.ArmorPiece;
import com.lunarclient.apollo.module.limb.BodyPart;
import com.lunarclient.apollo.module.limb.LimbModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class LimbModuleImpl
extends LimbModule {
    @Override
    public void hideArmorPieces(@NonNull Recipients recipients, @NonNull UUID playerUuid, @NonNull Collection<ArmorPiece> armorPieces) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (playerUuid == null) {
            throw new NullPointerException("playerUuid is marked non-null but is null");
        }
        if (armorPieces == null) {
            throw new NullPointerException("armorPieces is marked non-null but is null");
        }
        Set pieces = armorPieces.stream().map(this::toProtobuf).collect(Collectors.toSet());
        HideArmorPiecesMessage message = HideArmorPiecesMessage.newBuilder().setPlayerUuid(NetworkTypes.toProtobuf(playerUuid)).addAllArmorPieces(pieces).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetArmorPieces(@NonNull Recipients recipients, @NonNull UUID playerUuid, @NonNull Collection<ArmorPiece> armorPieces) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (playerUuid == null) {
            throw new NullPointerException("playerUuid is marked non-null but is null");
        }
        if (armorPieces == null) {
            throw new NullPointerException("armorPieces is marked non-null but is null");
        }
        Set pieces = armorPieces.stream().map(this::toProtobuf).collect(Collectors.toSet());
        ResetArmorPiecesMessage message = ResetArmorPiecesMessage.newBuilder().setPlayerUuid(NetworkTypes.toProtobuf(playerUuid)).addAllArmorPieces(pieces).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void hideBodyParts(@NonNull Recipients recipients, @NonNull UUID playerUuid, @NonNull Collection<BodyPart> bodyParts) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (playerUuid == null) {
            throw new NullPointerException("playerUuid is marked non-null but is null");
        }
        if (bodyParts == null) {
            throw new NullPointerException("bodyParts is marked non-null but is null");
        }
        Set parts = bodyParts.stream().map(this::toProtobuf).collect(Collectors.toSet());
        HideBodyPartMessage message = HideBodyPartMessage.newBuilder().setPlayerUuid(NetworkTypes.toProtobuf(playerUuid)).addAllBodyParts(parts).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetBodyParts(@NonNull Recipients recipients, @NonNull UUID playerUuid, @NonNull Collection<BodyPart> bodyParts) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (playerUuid == null) {
            throw new NullPointerException("playerUuid is marked non-null but is null");
        }
        if (bodyParts == null) {
            throw new NullPointerException("bodyParts is marked non-null but is null");
        }
        Set parts = bodyParts.stream().map(this::toProtobuf).collect(Collectors.toSet());
        ResetBodyPartMessage message = ResetBodyPartMessage.newBuilder().setPlayerUuid(NetworkTypes.toProtobuf(playerUuid)).addAllBodyParts(parts).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    private com.lunarclient.apollo.limb.v1.ArmorPiece toProtobuf(ArmorPiece armorPiece) {
        return com.lunarclient.apollo.limb.v1.ArmorPiece.forNumber(armorPiece.ordinal() + 1);
    }

    private com.lunarclient.apollo.limb.v1.BodyPart toProtobuf(BodyPart bodyPart) {
        return com.lunarclient.apollo.limb.v1.BodyPart.forNumber(bodyPart.ordinal() + 1);
    }
}

