/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.nametag;

import com.lunarclient.apollo.common.ApolloComponent;
import com.lunarclient.apollo.module.nametag.Nametag;
import com.lunarclient.apollo.module.nametag.NametagModule;
import com.lunarclient.apollo.nametag.v1.OverrideNametagMessage;
import com.lunarclient.apollo.nametag.v1.ResetNametagMessage;
import com.lunarclient.apollo.nametag.v1.ResetNametagsMessage;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class NametagModuleImpl
extends NametagModule {
    @Override
    public void overrideNametag(@NonNull Recipients recipients, @NonNull UUID playerUuid, @NonNull Nametag nametag) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (playerUuid == null) {
            throw new NullPointerException("playerUuid is marked non-null but is null");
        }
        if (nametag == null) {
            throw new NullPointerException("nametag is marked non-null but is null");
        }
        List<String> lines = nametag.getLines().stream().map(ApolloComponent::toJson).collect(Collectors.toList());
        OverrideNametagMessage message = OverrideNametagMessage.newBuilder().setPlayerUuid(NetworkTypes.toProtobuf(playerUuid)).addAllAdventureJsonLines(lines).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetNametag(@NonNull Recipients recipients, @NonNull UUID playerUuid) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (playerUuid == null) {
            throw new NullPointerException("playerUuid is marked non-null but is null");
        }
        ResetNametagMessage message = ResetNametagMessage.newBuilder().setPlayerUuid(NetworkTypes.toProtobuf(playerUuid)).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetNametags(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetNametagsMessage message = ResetNametagsMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

