/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.staffmod;

import com.lunarclient.apollo.module.staffmod.StaffMod;
import com.lunarclient.apollo.module.staffmod.StaffModModule;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import com.lunarclient.apollo.staffmod.v1.DisableStaffModsMessage;
import com.lunarclient.apollo.staffmod.v1.EnableStaffModsMessage;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class StaffModModuleImpl
extends StaffModModule {
    private final Set<com.lunarclient.apollo.staffmod.v1.StaffMod> staffMods = Arrays.stream(StaffMod.values()).map(this::toProtobuf).collect(Collectors.toSet());
    private final EnableStaffModsMessage enableAllStaffModsMessage = EnableStaffModsMessage.newBuilder().addAllStaffMods(this.staffMods).build();
    private final DisableStaffModsMessage disableAllStaffModsMessage = DisableStaffModsMessage.newBuilder().addAllStaffMods(this.staffMods).build();

    @Override
    public void enableStaffMods(@NonNull Recipients recipients, @NonNull List<StaffMod> mods) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (mods == null) {
            throw new NullPointerException("mods is marked non-null but is null");
        }
        Set staffModsProto = mods.stream().map(this::toProtobuf).collect(Collectors.toSet());
        EnableStaffModsMessage message = EnableStaffModsMessage.newBuilder().addAllStaffMods(staffModsProto).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void disableStaffMods(@NonNull Recipients recipients, @NonNull List<StaffMod> mods) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (mods == null) {
            throw new NullPointerException("mods is marked non-null but is null");
        }
        Set staffModsProto = mods.stream().map(this::toProtobuf).collect(Collectors.toSet());
        DisableStaffModsMessage message = DisableStaffModsMessage.newBuilder().addAllStaffMods(staffModsProto).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void enableAllStaffMods(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(this.enableAllStaffModsMessage));
    }

    @Override
    public void disableAllStaffMods(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(this.disableAllStaffModsMessage));
    }

    private com.lunarclient.apollo.staffmod.v1.StaffMod toProtobuf(StaffMod staffMod) {
        return com.lunarclient.apollo.staffmod.v1.StaffMod.forNumber(staffMod.ordinal() + 1);
    }
}

