/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.team;

import com.lunarclient.apollo.common.ApolloComponent;
import com.lunarclient.apollo.module.team.TeamMember;
import com.lunarclient.apollo.module.team.TeamModule;
import com.lunarclient.apollo.network.NetworkTypes;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import com.lunarclient.apollo.team.v1.ResetTeamMembersMessage;
import com.lunarclient.apollo.team.v1.UpdateTeamMembersMessage;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class TeamModuleImpl
extends TeamModule {
    @Override
    public void updateTeamMembers(@NonNull Recipients recipients, @NonNull List<TeamMember> teamMembers) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (teamMembers == null) {
            throw new NullPointerException("teamMembers is marked non-null but is null");
        }
        List teamMembersProto = teamMembers.stream().map(teamMember -> com.lunarclient.apollo.team.v1.TeamMember.newBuilder().setPlayerUuid(NetworkTypes.toProtobuf(teamMember.getPlayerUuid())).setAdventureJsonPlayerName(ApolloComponent.toJson(teamMember.getDisplayName())).setLocation(NetworkTypes.toProtobuf(teamMember.getLocation())).setMarkerColor(NetworkTypes.toProtobuf(teamMember.getMarkerColor())).build()).collect(Collectors.toList());
        UpdateTeamMembersMessage message = UpdateTeamMembersMessage.newBuilder().addAllMembers(teamMembersProto).build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }

    @Override
    public void resetTeamMembers(@NonNull Recipients recipients) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        ResetTeamMembersMessage message = ResetTeamMembersMessage.getDefaultInstance();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

