/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.tebex;

import com.lunarclient.apollo.module.tebex.TebexModule;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.recipients.Recipients;
import com.lunarclient.apollo.tebex.v1.OpenTebexEmbeddedCheckoutMessage;
import lombok.NonNull;

public final class TebexModuleImpl
extends TebexModule {
    @Override
    public void displayTebexEmbeddedCheckout(@NonNull Recipients recipients, @NonNull String basketIdent) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (basketIdent == null) {
            throw new NullPointerException("basketIdent is marked non-null but is null");
        }
        this.displayTebexEmbeddedCheckout(recipients, basketIdent, null);
    }

    @Override
    public void displayTebexEmbeddedCheckout(@NonNull Recipients recipients, @NonNull String basketIdent, String locale) {
        if (recipients == null) {
            throw new NullPointerException("recipients is marked non-null but is null");
        }
        if (basketIdent == null) {
            throw new NullPointerException("basketIdent is marked non-null but is null");
        }
        OpenTebexEmbeddedCheckoutMessage.Builder builder = OpenTebexEmbeddedCheckoutMessage.newBuilder().setBasketIdent(basketIdent);
        if (locale != null) {
            builder.setLocale(locale);
        }
        OpenTebexEmbeddedCheckoutMessage message = builder.build();
        recipients.forEach(player -> ((AbstractApolloPlayer)player).sendPacket(message));
    }
}

