/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.module.transfer;

import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.async.Future;
import com.lunarclient.apollo.event.ApolloReceivePacketEvent;
import com.lunarclient.apollo.libs.protobuf.ByteString;
import com.lunarclient.apollo.module.transfer.PingRequest;
import com.lunarclient.apollo.module.transfer.PingResponse;
import com.lunarclient.apollo.module.transfer.TransferModule;
import com.lunarclient.apollo.module.transfer.TransferRequest;
import com.lunarclient.apollo.module.transfer.TransferResponse;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.player.ApolloPlayer;
import com.lunarclient.apollo.roundtrip.ApolloResponse;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class TransferModuleImpl
extends TransferModule {
    public TransferModuleImpl() {
        this.handle(ApolloReceivePacketEvent.class, this::onTransferResponse);
    }

    @Override
    public Future<PingResponse> ping(@NonNull ApolloPlayer player, @NonNull PingRequest request) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        com.lunarclient.apollo.transfer.v1.PingRequest requestProto = com.lunarclient.apollo.transfer.v1.PingRequest.newBuilder().setRequestId(ByteString.copyFromUtf8(request.getRequestId().toString())).addAllServerIps(request.getServerIps()).build();
        return ((AbstractApolloPlayer)player).sendRoundTripPacket(request, requestProto);
    }

    @Override
    public Future<TransferResponse> transfer(@NonNull ApolloPlayer player, @NonNull TransferRequest request) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        com.lunarclient.apollo.transfer.v1.TransferRequest requestProto = com.lunarclient.apollo.transfer.v1.TransferRequest.newBuilder().setRequestId(ByteString.copyFromUtf8(request.getRequestId().toString())).setServerIp(request.getServerIp()).build();
        return ((AbstractApolloPlayer)player).sendRoundTripPacket(request, requestProto);
    }

    private void onTransferResponse(ApolloReceivePacketEvent event) {
        event.unpack(com.lunarclient.apollo.transfer.v1.TransferResponse.class).ifPresent(packet -> {
            ApolloResponse transferResponse = ((TransferResponse.TransferResponseBuilder)((TransferResponse.TransferResponseBuilder)TransferResponse.builder().packetId(UUID.fromString(packet.getRequestId().toStringUtf8()))).status(TransferResponse.Status.values()[packet.getStatusValue() - 1])).build();
            ApolloManager.getRoundtripManager().handleResponse(transferResponse);
        });
        event.unpack(com.lunarclient.apollo.transfer.v1.PingResponse.class).ifPresent(packet -> {
            List<PingResponse.PingData> pingData = packet.getPingDataList().stream().map(data -> PingResponse.PingData.builder().serverIp(data.getServerIp()).status(PingResponse.PingData.Status.values()[data.getStatusValue() - 1]).pingMillis(data.getPing()).build()).collect(Collectors.toList());
            ApolloResponse pingResponse = ((PingResponse.PingResponseBuilder)((PingResponse.PingResponseBuilder)PingResponse.builder().packetId(UUID.fromString(packet.getRequestId().toStringUtf8()))).data(pingData)).build();
            ApolloManager.getRoundtripManager().handleResponse(pingResponse);
        });
    }
}

