/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.network;

import com.lunarclient.apollo.Apollo;
import com.lunarclient.apollo.ApolloManager;
import com.lunarclient.apollo.event.ApolloReceivePacketEvent;
import com.lunarclient.apollo.event.ApolloSendPacketEvent;
import com.lunarclient.apollo.event.EventBus;
import com.lunarclient.apollo.libs.protobuf.Any;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.player.ApolloPlayer;
import java.util.UUID;
import lombok.Generated;

public final class ApolloNetworkManager {
    public void sendPacket(ApolloPlayer player, Any message) {
        EventBus.EventResult<ApolloSendPacketEvent> result = EventBus.getBus().post(new ApolloSendPacketEvent(player, message));
        if (!result.getEvent().isCancelled()) {
            ((AbstractApolloPlayer)player).sendPacket(message.toByteArray());
        }
        for (Throwable throwable : result.getThrowing()) {
            throwable.printStackTrace();
        }
    }

    public void receivePacket(ApolloPlayer player, Any message) {
        EventBus.EventResult<ApolloReceivePacketEvent> result = EventBus.getBus().post(new ApolloReceivePacketEvent(player, message));
        for (Throwable throwable : result.getThrowing()) {
            throwable.printStackTrace();
        }
    }

    public void receivePacket(UUID player, byte[] bytes) {
        Apollo.getPlayerManager().getPlayer(player).ifPresent(apolloPlayer -> {
            try {
                ApolloManager.getNetworkManager().receivePacket((ApolloPlayer)apolloPlayer, Any.parseFrom(bytes));
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    @Generated
    public ApolloNetworkManager() {
    }
}

