/*
 * Decompiled with CFR 0.152.
 */
package com.lunarclient.apollo.network;

import com.lunarclient.apollo.configurable.v1.ConfigurableSettings;
import com.lunarclient.apollo.configurable.v1.OverrideConfigurableSettingsMessage;
import com.lunarclient.apollo.libs.protobuf.Value;
import com.lunarclient.apollo.module.ApolloModule;
import com.lunarclient.apollo.option.Option;
import com.lunarclient.apollo.option.Options;
import com.lunarclient.apollo.option.OptionsImpl;
import com.lunarclient.apollo.player.AbstractApolloPlayer;
import com.lunarclient.apollo.player.ApolloPlayer;
import org.jetbrains.annotations.Nullable;

public final class NetworkOptions {
    public static void sendOption(@Nullable ApolloModule module, Option<?, ?, ?> key, Value value, Iterable<ApolloPlayer> players) {
        if (!key.isNotify()) {
            return;
        }
        OverrideConfigurableSettingsMessage.Builder modulesBuilder = OverrideConfigurableSettingsMessage.newBuilder();
        ConfigurableSettings.Builder moduleBuilder = NetworkOptions.module(module);
        moduleBuilder.putProperties(key.getKey(), value);
        modulesBuilder.addConfigurableSettings(moduleBuilder.build());
        for (ApolloPlayer player : players) {
            ((AbstractApolloPlayer)player).sendPacket(modulesBuilder.build());
        }
    }

    public static void sendOptions(Iterable<ApolloModule> modules, boolean onlyPresent, ApolloPlayer ... players) {
        for (ApolloPlayer player : players) {
            OverrideConfigurableSettingsMessage.Builder modulesBuilder = OverrideConfigurableSettingsMessage.newBuilder();
            for (ApolloModule module : modules) {
                modulesBuilder.addConfigurableSettings(NetworkOptions.moduleWithOptions(module, onlyPresent).build());
            }
            ((AbstractApolloPlayer)player).sendPacket(modulesBuilder.build());
        }
    }

    private static ConfigurableSettings.Builder moduleWithOptions(ApolloModule module, boolean onlyPresent) {
        ConfigurableSettings.Builder builder = NetworkOptions.module(module);
        Options options = module.getOptions();
        for (Option option : options) {
            if (!option.isNotify()) continue;
            Value.Builder valueBuilder = Value.newBuilder();
            Object value = options.get(option);
            if (value == null && onlyPresent) continue;
            Value wrapper = ((OptionsImpl)options).wrapValue(valueBuilder, option.getTypeToken().getType(), value);
            builder.putProperties(option.getKey(), wrapper);
        }
        return builder;
    }

    private static ConfigurableSettings.Builder module(@Nullable ApolloModule module) {
        return ConfigurableSettings.newBuilder().setApolloModule(module == null ? "apollo" : module.getId()).setEnable(module == null || module.isEnabled());
    }

    private NetworkOptions() {
    }
}

